// /******************************************************************************
//  * File: XRQCHTHandSkeletonDriver.cs
//  * Copyright (c) 2025 Qualcomm Technologies, Inc. and/or its subsidiaries. All rights reserved.
//  *
//  * Confidential and Proprietary - Qualcomm Technologies, Inc.
//  *
//  ******************************************************************************/

#if XR_HANDS
using QCHT.Interactions.Core;
using Unity.XR.CoreUtils;
using UnityEngine;
using UnityEngine.XR.Hands;

namespace QCHT.Interactions.Hands.XRHands
{
    public class XRQCHTHandSkeletonDriver : XRHandSkeletonDriver
    {
        protected override void OnJointsUpdated(XRHandJointsUpdatedEventArgs args)
        {
            UpdateJointWorldPoses(args);

            ApplyUpdatedTransformPoses();
        }

        protected void UpdateJointWorldPoses(XRHandJointsUpdatedEventArgs args)
        {
            for (var index = 0; index < m_JointLocalPoses.Length; index++)
            {
                var joint = args.hand.GetJoint((XRHandJointID)index + 1);
                if (joint.TryGetPose(out var pose))
                {
                    XROriginUtility.TransformPose(ref pose);
                    
                    m_JointLocalPoses[index] = pose;
                }
            }
        }

        protected override void ApplyUpdatedTransformPoses()
        {
            for (var i = 0; i < m_JointTransforms.Length; i++)
            {
                if (m_HasJointTransformMask[i])
                {
#if UNITY_EDITOR || DEVELOPMENT_BUILD
                    if (m_JointTransforms[i] == null)
                    {
                        continue;
                    }
#endif
                    m_JointTransforms[i].SetWorldPose(m_JointLocalPoses[i]);
                }
            }
        }
    }
}
#endif