// /******************************************************************************
//  * File: XRHandTrackingSubsystem.Provider.cs
//  * Copyright (c) 2023 Qualcomm Technologies, Inc. and/or its subsidiaries. All rights reserved.
//  *
//  * Confidential and Proprietary - Qualcomm Technologies, Inc.
//  *
//  ******************************************************************************/

using UnityEngine.SubsystemsImplementation;

namespace QCHT.Interactions.Core
{
    public partial class XRHandTrackingSubsystem
    {
        public abstract class Provider : SubsystemProvider<XRHandTrackingSubsystem>
        {
            /// <summary>
            /// Gets the space which provider hand data are formatted. 
            /// </summary>
            public XrSpace Space { get; protected set; } = XrSpace.XR_HAND_WORLD;

            /// <summary>
            /// Tries to get hand data 
            /// </summary>
            /// <param name="hand"> hand to update </param>
            /// <returns></returns>
            public abstract HandTrackingStatus TryUpdateHandData(ref Hand hand);
            
            public override void Start() { }

            public override void Stop() { }

            public override void Destroy() { }
        }
    }
}