// /******************************************************************************
//  * File: HandTrackingOpenXRPlugin.cs
//  * Copyright (c) 2023 Qualcomm Technologies, Inc. and/or its subsidiaries. All rights reserved.
//  *
//  * Confidential and Proprietary - Qualcomm Technologies, Inc.
//  *
//  ******************************************************************************/

using System;
using System.Runtime.InteropServices;

namespace QCHT.Interactions.Core.OpenXR
{
    internal static class HandTrackingOpenXRPlugin
    {
        private const string DllName = "QCHTOpenXRPlugin";

        #region Common

        [DllImport(DllName)]
        internal static extern IntPtr HookGetInstanceProcAddr(IntPtr func);
        
        [DllImport(DllName)]
        internal static extern int SetAppSpace(ulong xrSpace);

        #endregion

        #region XR_EXT_hand_tracking

        [DllImport(DllName)]
        internal static extern bool IsHandTrackingSupported();

        [DllImport(DllName)]
        internal static extern XrResult TryLocateHandJoints(XrHandEXT handedness,
            ref bool isTracked,
            [MarshalAs(UnmanagedType.LPArray, SizeConst = (int)XrHandJoint.XR_HAND_JOINT_MAX)]
            XrPosef[] handPoses,
            [MarshalAs(UnmanagedType.LPArray, SizeConst = (int)XrHandJoint.XR_HAND_JOINT_MAX)]
            float[] radius);

        #endregion

        #region XR_QCOM_hand_tracking_gesture

        [DllImport(DllName)]
        internal static extern XrResult TryGetHandGestureData(XrHandEXT handExt, ref XrHandGestureQCOM data);

        #endregion

        #region XR_QCOMV2_hand_tracking_gesture

        [DllImport(DllName)]
        internal static extern XrResult TryGetInteractionData(XrHandEXT handExt, ref XrHandGestureV2QCOM data);

        #endregion

        #region XR_MSFT_hand_tracking_mesh

        [DllImport(DllName)]
        internal static extern bool IsHandTrackingMeshMSFTSupported(ref int maxHandMeshIndexCount,
            ref int maxHandMeshVertexCount);

        [DllImport(DllName)]
        internal static extern XrResult TryGetHandMeshMSFT(XrHandEXT handExt, ref XrHandMeshMSFT handMesh,
            ref XrPosef pose);

        #endregion

        #region XR_FB_hand_tracking_mesh

        [DllImport(DllName)]
        internal static extern bool IsHandTrackingMeshFBSupported();

        [DllImport(DllName)]
        internal static extern XrResult TryGetHandMeshFB(XrHandEXT handExt, ref XrHandTrackingMeshFB handMesh);

        #endregion

        #region Passthrough

        [DllImport(DllName)]
        internal static extern bool IsPassthroughSupported();

        [DllImport(DllName)]
        internal static extern void SetPassthroughEnabled(bool enable);

        [DllImport(DllName)]
        internal static extern bool GetPassthroughEnabled();

        #endregion
    }
}