// /******************************************************************************
//  * File: HandTrackingMeshFBFeature.FeatureValidation.cs
//  * Copyright (c) 2024 Qualcomm Technologies, Inc. and/or its subsidiaries. All rights reserved.
//  *
//  * Confidential and Proprietary - Qualcomm Technologies, Inc.
//  *
//  ******************************************************************************/

using System.Collections.Generic;
using UnityEditor;
using UnityEngine.XR.OpenXR;

#if XR_HANDS
using HandTrackingFeature = UnityEngine.XR.Hands.OpenXR.HandTracking;
#endif

#if UNITY_EDITOR
namespace QCHT.Interactions.Core
{
    public partial class HandTrackingMeshFBFeature
    {
        protected override void GetValidationChecks(List<ValidationRule> rules, BuildTargetGroup targetGroup)
        {
            rules.Add(new ValidationRule(this)
            {
                message = "XR_EXT_hand_tracking feature should be enabled to use this feature.",
                checkPredicate = () =>
                {
                    var settings = OpenXRSettings.GetSettingsForBuildTargetGroup(targetGroup);
                    var feature = settings.GetFeature<HandTrackingFeature>();
                    if (feature == null || feature.enabled == false)
                    {
                        return false;
                    }

                    return true;
                },
                fixIt = () =>
                {
                    var settings = OpenXRSettings.GetSettingsForBuildTargetGroup(targetGroup);
                    var feature = settings.GetFeature<HandTrackingFeature>();
                    if (feature == null)
                    {
                        return;
                    }

                    feature.enabled = true;
                }
            });
        }
    }
}
#endif