// /******************************************************************************
//  * File: HandTrackingFeature.FeatureValidation.cs
//  * Copyright (c) 2023 Qualcomm Technologies, Inc. and/or its subsidiaries. All rights reserved.
//  *
//  * Confidential and Proprietary - Qualcomm Technologies, Inc.
//  *
//  ******************************************************************************/

#if !XR_HANDS && UNITY_EDITOR
using System.Collections.Generic;
using UnityEditor;
using UnityEngine;

namespace QCHT.Interactions.Core
{
    public partial class HandTrackingFeature
    {
        protected override void GetValidationChecks(List<ValidationRule> rules, BuildTargetGroup targetGroup)
        {
            rules.Add(new ValidationRule(this)
            {
                message = "At least 4 bones skin weights is required for suitable hand mesh quality",
                checkPredicate = () =>
                {
                    var levels = QualitySettings.names;
                    var quality = QualitySettings.GetQualityLevel(); // save current quality settings
                    var isOk = true;
                    
                    for (var i = 0; i < levels.Length; i++)
                    {
                        QualitySettings.SetQualityLevel(i);
                        isOk &= QualitySettings.skinWeights >= SkinWeights.FourBones;
                    }

                    QualitySettings.SetQualityLevel(quality); // restore quality settings

                    return isOk;
                },
                fixIt = () =>
                {
                    var levels = QualitySettings.names;
                    var quality = QualitySettings.GetQualityLevel(); // save current quality settings
                    for (var i = 0; i < levels.Length; i++)
                    {
                        QualitySettings.SetQualityLevel(i);
                        if (QualitySettings.skinWeights < SkinWeights.FourBones)
                            QualitySettings.skinWeights = SkinWeights.FourBones;
                    }

                    QualitySettings.SetQualityLevel(quality); // restore quality settings
                }
            });
        }
    }
}
#endif