/*
 * Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
 * All rights reserved.
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 */

package com.qualcomm.snapdragon.spaces.hostcontroller;

import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Intent;
import android.os.Bundle;
import com.qualcomm.snapdragon.spaces.hostcontroller.ui.spaces_controller.HostControllerFragment;
import com.qualcomm.snapdragon.spaces.helpers.LaunchHelper;

public class HostController {

    public static void ResetPose() {
        HostControllerFragment.Companion.ResetPose();
    }

    public static void StartControllerActivityOnHandset(Activity activity) {
        if (LaunchHelper.HasCustomController()) {
            Intent controllerIntent = new Intent(activity.getIntent());
            Bundle startupBundle = null;
            controllerIntent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
            controllerIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
            controllerIntent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
            controllerIntent.setClassName(activity, ControllerActivity.class.getName());
            startupBundle = ActivityOptions.makeBasic().setLaunchDisplayId(0).toBundle();
            controllerIntent.putExtras(startupBundle);

            activity.startActivity(controllerIntent, startupBundle);
        }
    }
}
