/******************************************************************************
 * File: DRFEmptySecondScreenActivity.java
 * Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
 * All rights reserved.
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ******************************************************************************/

package com.qualcomm.snapdragon.spaces.helpers;

import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;

import com.qualcomm.qti.device.access.*;

public class DRFEmptySecondScreenActivity extends Activity {
    private static final String TAG = "Spaces-DRFEmptySecondScreenActivity";

    private static DRFEmptySecondScreenActivity _instance;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (_instance != null)
        {
            Log.v(TAG, "Found existing activity instance, killing it.");
            _instance.finish();
            _instance = null;
        }
        
        _instance = this;
        Log.v(TAG, "Application was started with intent flags: " + getIntent().getFlags());
        setTheme(android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);
    }

    @Override
    protected void onDestroy() {
        Log.v(TAG, "onDestroy called");
        super.onDestroy();
    }

    public static void TryStartThisActivityOnSecondScreen(Activity a) {
        try {
            DeviceAccessManager dam = new DeviceAccessManager(null);
            dam.start(a);
            int id = dam.getLaunchDisplayId(true);
            Log.v(TAG, "Launch displayId: " + id);
            if (_instance != null)
            {
                Log.v(TAG, "Found existing activity instance, not launching new one.");
                return;
            }
            
            if (id != 0)
            {
                //If we have a second display, start this on it to pause any running app so DRF works without double rendering
                Intent mainLaunchIntent = new Intent();
                Bundle startupBundle = null;
                mainLaunchIntent.setClassName(a, DRFEmptySecondScreenActivity.class.getName());
                mainLaunchIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
                mainLaunchIntent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    startupBundle = ActivityOptions.makeBasic().setLaunchDisplayId(id).toBundle();
                }
                mainLaunchIntent.putExtras(startupBundle);

                a.startActivity(mainLaunchIntent, startupBundle);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void FinishDRFEmptyActivity() {
        Log.v(TAG, "FinishDRFEmptyActivity(), trying to finish: " + (_instance == null ? "no activity instance" : "will call finish"));
        if (_instance != null) {
            _instance.finish();
	    _instance = null;
        }
    }
}
