/*
 * Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
 * All rights reserved.
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 */

package com.qualcomm.qti.device.access;

import com.qualcomm.qti.device.access.MainInterfaceCallback;

interface MainInterface {
    /***************************************************************************//**
     * Creates a virtual display with name "WirelessXRDisplay" when the wireless
     * display is connected to the phone.
     * \return
     *    Display ID upon success, -1 otherwise
     ***************************************************************************/
    int createWirelessXrVd();

    void destroyWirelessVd();

    void registerCallback(MainInterfaceCallback cb);

    void unregisterCallback(MainInterfaceCallback cb);

    // 0 = disconnected, 1 = AIO, 2 = Wired, 3 = Wireless
    int getDeviceType();
}
