/****************************************************************************
 * File: Uri.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include "JavaEnvironment.hpp"

#include <string>

namespace wikitude::android::net {
    class Uri {
    public:
        Uri(const wikitude::android::JavaEnvironment& environment_, jobject obj_ = nullptr);

        Uri parse(const std::string& uriString_);
        Uri parse(jstring uriString_);

        jobject getObject() const noexcept {
            return _object;
        }

    private:
        void initClass();
        void initMethods();

    private:
        static const char* _CLASS_NAME;
        const wikitude::android::JavaEnvironment& _env;
        jclass _class;
        jmethodID _parseMethodId;
        jobject _object;
    };
}    // wikitude::android::net
