/****************************************************************************
 * File: PackageManager.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include "ApplicationInfo.hpp"
#include "AndroidContextManager.hpp"
#include "PackageInfo.hpp"

#include <string_view>

namespace wikitude::android::app {
    class Activity;
}

namespace wikitude::android::content::pm {

    class PackageManager {
        friend class wikitude::android::app::Activity;

    public:
        enum ApplicationInfoFlags { GET_META_DATA = 128 };

        PackageInfo getPackageInfo(std::string_view packageName_, int flags_);
        PackageInfo getPackageInfo(jstring packageName_, int flags_);

        ApplicationInfo getApplicationInfo(jstring packageName, int flags_);
        ApplicationInfo getApplicationInfo(std::string_view packageName, int flags_);

    private:
        PackageManager(const wikitude::android::AndroidContextManager& androidContextManager, jobject obj);

        void initClass(const JavaEnvironment& env);
        void initMethods(const JavaEnvironment& env);

    private:
        static const char* _CLASS_NAME;
        const wikitude::android::AndroidContextManager& _androidContextManager;
        jclass _class;
        jobject _object;
        jmethodID _getPackageInfoMethodId;
        jmethodID _getApplicationInfoMethodId;
    };
}
