/****************************************************************************
 * File: PackageInfo.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include "AndroidContextManager.hpp"

#include <string>

namespace wikitude::android::content::pm {
    class PackageInfo {
        friend class PackageManager;

    public:
        jobject getObject() const noexcept {
            return _object;
        }

        [[nodiscard]] std::string versionName() const noexcept {
            return _versionName;
        }

    private:
        PackageInfo(const wikitude::android::AndroidContextManager& androidContextManager, jobject obj);
        void initClass(const JavaEnvironment& env);
        void initMethods(const JavaEnvironment& env);

    private:
        static const char* _CLASS_NAME;
        const wikitude::android::AndroidContextManager& _androidContextManager;
        jclass _class;
        jfieldID _versionNameFieldId;
        jobject _object;
        std::string _versionName;
    };
}    // wikitude::android::content::pm
