/****************************************************************************
 * File: JavaEnvironment.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include <jni.h>
#include <thread>

namespace wikitude::android {
    /**
     * Helper class to handle a Java Environment.
     */
    class JavaEnvironment {
    public:
        JavaEnvironment(JavaVM* jvm_);
        ~JavaEnvironment();

        JavaEnvironment(const JavaEnvironment&) = delete;
        JavaEnvironment& operator=(const JavaEnvironment&) = delete;

        JavaEnvironment(JavaEnvironment&&) = delete;
        JavaEnvironment& operator=(JavaEnvironment&&) = delete;

        JNIEnv* getEnvironment() const noexcept {
            return _env;
        }

    private:
        const size_t _threadId;
        JavaVM* _jvm = nullptr;
        JNIEnv* _env = nullptr;
        bool _attached = false;
    };
}
