/****************************************************************************
 * File: Cursor.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include "JavaEnvironment.hpp"

#include <string>

namespace wikitude::android::content {
    class ContentResolver;
}    // wikitude::android::content

namespace wikitude::android::database {
    class Cursor {
        friend class content::ContentResolver;    // Only the ContentResolver is allowed to creat me

    public:
        bool moveToFirst();
        bool moveToNext();
        int getColumnIndex(jstring columnName_);
        int getColumnIndex(const char* columnName_);
        std::string getString(int columnIndex_);
        void close();

    private:
        Cursor(const wikitude::android::JavaEnvironment& environment_, jobject obj_);

        void initClass();
        void initMethods();

    private:
        static const char* _CLASS_NAME;
        const wikitude::android::JavaEnvironment& _env;

        jclass _class;
        jmethodID _moveToFirstMethodId;
        jmethodID _moveToNextMethodId;
        jmethodID _getColumnIndexMethodId;
        jmethodID _getStringMethodId;
        jmethodID _closeMethodId;
        jobject _object;
    };
}    // wikitude::android::net::database
