/****************************************************************************
 * File: Context.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include "ContentResolver.hpp"
#include "JavaEnvironment.hpp"

// Forward declarations
namespace wikitude::android::app {
    class Activity;
}

namespace wikitude::android::content {
    class Context {
    public:
        Context(const wikitude::android::JavaEnvironment& environment_, const wikitude::android::app::Activity& activity_);
        ContentResolver getContentResolver();

    private:
        void initClass();
        void initMethods();

    private:
        static const char* _CLASS_NAME;
        const wikitude::android::JavaEnvironment& _env;
        const wikitude::android::app::Activity& _activity;
        jclass _class;
        jmethodID _getContentResolverMethodId;
    };
}    // wikitude::android::content
