/****************************************************************************
 * File: ContentResolver.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include "Cursor.hpp"
#include "Uri.hpp"

namespace wikitude::android::content {
    class ContentResolver {
        friend class Context;    // Only the Context can create me

    public:
        database::Cursor query(const net::Uri& uri_, jobjectArray projection_ = nullptr, jstring selection_ = nullptr, jobjectArray selectionArgs_ = nullptr, jstring sortOrder_ = nullptr);

    private:
        ContentResolver(const wikitude::android::JavaEnvironment& environment_, jobject obj_);

        void initClass();
        void initMethods();

    private:
        static const char* _CLASS_NAME;
        const wikitude::android::JavaEnvironment& _env;
        jclass _class;
        jmethodID _queryMethodId;
        jobject _object;
    };
}
