/****************************************************************************
 * File: Bundle.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include "AndroidContextManager.hpp"

#include <jni.h>

#include <optional>
#include <string>
#include <string_view>

struct XrInstanceCreateInfo;

namespace wikitude::android::content::pm {
    class ApplicationInfo;
}

namespace wikitude::android::os {
    class Bundle {
        friend class wikitude::android::content::pm::ApplicationInfo;

    public:
        [[nodiscard]] std::optional<std::string> getString(std::string_view key_);
        [[nodiscard]] std::optional<std::string> getString(jstring key_);

    private:
        Bundle(const wikitude::android::AndroidContextManager& androidContextManager_, jobject obj_);

        void initClass(const JavaEnvironment& env);
        void initMethods(const JavaEnvironment& env);

    private:
        const wikitude::android::AndroidContextManager& _androidContextManager;
        jobject _object;
        jclass _class;
        jmethodID _getStringMethodId;
    };
}    // wikitude::android::os
