/****************************************************************************
 * File: Build.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include <jni.h>

#include <string>

struct XrInstanceCreateInfo;

namespace wikitude::android::os {
    class Build {
    public:
        Build(const XrInstanceCreateInfo* info_);

        [[nodiscard]] std::string MODEL() const noexcept {
            return _model;
        }

        [[nodiscard]] std::string DISPLAY() const noexcept {
            return _display;
        }

        [[nodiscard]] std::string FINGERPRINT() const noexcept {
            return _fingerprint;
        }

        [[nodiscard]] std::string USER() const noexcept {
            return _user;
        }

        [[nodiscard]] std::string ID() const noexcept {
            return _id;
        }

        class VERSION {
        public:
            VERSION(const XrInstanceCreateInfo* info_);

            [[nodiscard]] std::string BASE_OS() const noexcept {
                return _baseOS;
            }

            [[nodiscard]] int SDK_INT() const noexcept {
                return _sdkInt;
            }

            [[nodiscard]] std::string RELEASE() const noexcept {
                return _sdkRelease;
            }

        private:
            const char* _CLASS_NAME = "android/os/Build$VERSION";
            std::string _baseOS;
            int _sdkInt;
            std::string _sdkRelease;
        };

    private:
        const char* _CLASS_NAME = "android/os/Build";
        std::string _model;
        std::string _display;
        std::string _fingerprint;
        std::string _user;
        std::string _id;
    };
}    // wikitude::android::os
