/****************************************************************************
 * File: ApplicationInfo.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include "Bundle.hpp"
#include "AndroidContextManager.hpp"

namespace wikitude::android::content::pm {

    class ApplicationInfo {
        friend class PackageManager;

    public:
        android::os::Bundle metaData();

    private:
        ApplicationInfo(const wikitude::android::AndroidContextManager& androidContextManager_, jobject obj_);

        void initClass(const JavaEnvironment& env);
        void initMethods(const JavaEnvironment& env);

    private:
        static const char* _CLASS_NAME;
        const wikitude::android::AndroidContextManager& _androidContextManager;
        jclass _class;
        jobject _object;
        jmethodID _getPackageInfoMethodId;
        jfieldID _metaDataFieldId;
    };
}
