/******************************************************************************
 * File: AndroidContextManager.hpp
 *
 * Copyright (c) 2023-2024 Qualcomm Technologies, Inc.
 * All Rights Reserved
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ******************************************************************************/

#pragma once

#include "JavaEnvironment.hpp"

struct XrInstanceCreateInfo;
struct XrInstanceCreateInfoAndroidKHR;

namespace wikitude::android {

    /**
     * Get the XrInstanceCreateInfoAndroidKHR iterating throw the chain in the XrInstanceCreateInfo
     * @param info the XrInstanceCreateInfo comging from the InstanceCreateLayer function
     * @return the XrInstanceCreateInfoAndroidKHR* pointer or null if it wasn't find in the chain
     */
    const XrInstanceCreateInfoAndroidKHR* findAndroidCreateInfoInChain(const XrInstanceCreateInfo* info_);

    /**
     * Helper class to handle the Java Virtual Machine and the environment associated with it during the creation of the layer.
     */
    class AndroidContextManager {
    public:
        AndroidContextManager(const XrInstanceCreateInfo* info_);
        AndroidContextManager(const XrInstanceCreateInfoAndroidKHR* androidInfo_);
        ~AndroidContextManager();

        AndroidContextManager(const AndroidContextManager&) = delete;
        AndroidContextManager& operator=(const AndroidContextManager&) = delete;

        AndroidContextManager(AndroidContextManager&& rhs_) = delete;
        AndroidContextManager& operator=(AndroidContextManager&& rhs_) = delete;

        [[nodiscard]] JavaVM* getJavaVM() const noexcept {
            return _jvm;
        }

        [[nodiscard]] JavaEnvironment createJNIEnvironment() const noexcept;

    private:
        JavaVM* getJvmFromCreateInfo(const XrInstanceCreateInfoAndroidKHR* info_);

    private:
        JavaVM* _jvm = nullptr;
    };

} /* namespace wikitude::android */
