/****************************************************************************
 * File: AndroidActivity.hpp
 * Copyright (c) 2024 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include "AndroidContextManager.hpp"
#include "PackageManager.hpp"

struct XrInstanceCreateInfo;
struct XrInstanceCreateInfoAndroidKHR;

namespace wikitude::android::app {
    /**
     * Helper class to hold the Activity coming from XrInstanceCreateInfoAndroidKHR struct.
     */
    class Activity {
        friend class android::content::pm::PackageManager;

    public:
        Activity(const XrInstanceCreateInfoAndroidKHR* androidInfo_, const wikitude::android::AndroidContextManager& androidContextManager);
        Activity(const XrInstanceCreateInfo* info_, const wikitude::android::AndroidContextManager& androidContextManager);
        Activity(jobject activityObject, const wikitude::android::AndroidContextManager& androidContextManager);
        ~Activity();

        Activity(const Activity&) = delete;
        Activity& operator=(const Activity&) = delete;

        Activity(Activity&&) = delete;
        Activity& operator=(Activity&&) = delete;

        jobject getObject() const noexcept {
            return _activityObject;
        }

        std::string getPackageName();
        android::content::pm::PackageManager getPackageManager();

    private:
        void initClass(const JavaEnvironment& env);
        void initMethods(const JavaEnvironment& env);

    private:
        const android::AndroidContextManager& _androidContextManager;
        jobject _activityObject = nullptr;
        jclass _class;
        jmethodID _getPackageManagerMethodID;
        jmethodID _getPackageNameMethodId;
    };
}
