/****************************************************************************
 * File: OpenXrException.hpp
 * Copyright (c) 2023 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 *
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ***************************************************************************/

#pragma once

#include <stdexcept>

namespace wikitude::openxr {

class OpenXrException : public std::runtime_error {
public:
  OpenXrException(const std::string &message, XrResult errorCode)
      : std::runtime_error{message}, _errorCode{errorCode} {}

  [[nodiscard]] XrResult getOpenXrResult() const noexcept { return _errorCode; }

private:
  XrResult _errorCode;
};

} // namespace wikitude::openxr
