/******************************************************************************
 * File: MAXSystemWrapper.hpp
 *
 * Copyright (c) 2023 Qualcomm Technologies, Inc.
 * All Rights Reserved
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 *
 ******************************************************************************/

#pragma once

#include <memory>

#include <beta/QXRCoreClientMAX.h>

namespace wikitude::openxr {

    class MAXSystem {
    public:
        ~MAXSystem();
        MAXSystem(const MAXSystem&) = delete;
        MAXSystem& operator=(const MAXSystem&) = delete;

        static std::unique_ptr<MAXSystem> create(qvrservice_client_helper_t* qxrCoreClient_);

        MAXSystemHandle_t getHandle() {
            return _maxSystemHandle;
        };

    private:
        MAXSystem(qvrservice_client_helper_t* qxrCoreClient_, MAXSystemHandle_t maxSystemHandle_);

    private:
        qvrservice_client_helper_t* _qxrCoreClient;
        MAXSystemHandle_t _maxSystemHandle;
    };

    inline std::unique_ptr<MAXSystem> MAXSystem::create(qvrservice_client_helper_t* qxrCoreClient_) {
        MAXSystemHandle_t maxSystemHandle = nullptr;
        QXRCoreClient_GetMAXSystem(qxrCoreClient_, &maxSystemHandle);

        return maxSystemHandle ? std::unique_ptr<MAXSystem>(new MAXSystem(qxrCoreClient_, maxSystemHandle)) : nullptr;
    }

    inline MAXSystem::MAXSystem(qvrservice_client_helper_t* qxrCoreClient_, MAXSystemHandle_t maxSystemHandle_)
        : _qxrCoreClient(qxrCoreClient_)
        , _maxSystemHandle(maxSystemHandle_) {
    }

    inline MAXSystem::~MAXSystem() {
        QXRCoreClient_ReleaseMAXSystem(_qxrCoreClient, _maxSystemHandle);
    }

}
