/******************************************************************************
 * File: CubeManipulation.cs
 * Copyright (c) 2023-2024 Qualcomm Technologies, Inc. and/or its subsidiaries. All rights reserved.
 *
 ******************************************************************************/

// using Qualcomm.Snapdragon.Spaces; // TODO: コメントアウト戻し

using UnityEngine;
using UnityEngine.UI;

namespace com.nttconoq.devices.android.mirza.example
{
    public class CubeManipulation : MonoBehaviour
    {
        public GameObject cube;
        public MeshRenderer meshRenderer;

        public void SetColor(Image image)
        {
            meshRenderer.material.color = image.color;
        }

        /// <summary>
        /// aaa
        /// </summary>
        /// <param name="sliderRot"></param>
        public void UpdateRotation(Slider sliderRot)
        {
            var localEulerAngles = cube.transform.localEulerAngles;
            localEulerAngles.y = -sliderRot.value;

            cube.transform.localEulerAngles = localEulerAngles;
        }

        public void UpdateVisibility(Toggle toggle)
        {
            cube.SetActive(toggle.isOn);
        }

        public void PlaceCube()
        {
            // TODO: コメントアウト戻し
            // var c = OriginLocationUtility.GetOriginCamera();
            // if (c != null) cube.transform.position = c.transform.position + c.transform.forward * 1.25f;
        }
    }
}