using UnityEngine;

namespace com.nttqonoq.devices.android.mirzalibrary
{
    /// <summary>
    /// マイクモードの状態 Enum
    /// </summary>
    public enum MicMode 
    {
        Off = 0, // OFF（全方位）
        Wearer = 1, // 装着者集音
        Ambient = 2, // 周囲集音（装着者以外)
        Front = 3 // 前方集音（装着者以外の前方向）  
    }


    /// <summary>
    /// MIXモードの有無状態 Enum
    /// </summary>
    public enum MixMode
    {
        Off = 0, // OFF(しない)
        On = 1 // ON(する)
    }
    
    /// <summary>
    /// マイク切替状態
    /// </summary>
    public class SwitchMicrophoneStatus
    {
        public MicMode WearingMicMode { get; private set; }
        public MicMode FrontMicMode { get; private set; }
        public MixMode MixMode { get; private set; }


        public static SwitchMicrophoneStatus Convert(AndroidJavaObject javaObject)
        {
            var status = new SwitchMicrophoneStatus
            {
                WearingMicMode =
                    (MicMode)javaObject.Call<AndroidJavaObject>("getWearingMicMode")
                        .Call<int>("getCode"),
                FrontMicMode =
                    (MicMode)javaObject.Call<AndroidJavaObject>("getFrontMicMode")
                        .Call<int>("getCode"),
                MixMode =
                    (MixMode)javaObject.Call<AndroidJavaObject>("getMixMode")
                        .Call<int>("getCode")
            };
            return status;
        } 
    }
}