﻿using UnityEngine;

namespace NTTQONOQ.Android.MiRZA.Library.Samples.TouchSensorSample
{
    // キューブを操作するためのコントローラー
    public class CubeController : MonoBehaviour
    {
        [SerializeField]
        private GlassesTouchSensorEventTrigger glassesTouchSensorEventTrigger;

        [SerializeField]
        private GameObject cube;

        private float _rotationalInterval = 60f; // 回転角度
        private bool _isScaleUp = false; // 拡大状態かどうか
        private float _targetScale;
        private float _defaultScale;
        private bool _scaleUpByTouchSensorXCoordinateEnable = false;
        private Quaternion _targetRot; // 目標の回転位置
        private float _interpolant = 0.15f; // 回転速度


        private void Start()
        {
            _targetRot = cube.transform.localRotation;
            _defaultScale = cube.transform.localScale.x;
            _targetScale = _defaultScale;

            cube.GetComponent<Renderer>().material.color = Color.blue;
        }

        private void FixedUpdate()
        {
            UpdateRotate(); // キューブの回転　：指定した値まで回転させる
            UpdateScaleUp(); // キューブの拡大
            UpdateScaleUpByTouchSensorXCoordinate();
        }

        // キューブの回転　：指定した値まで回転させる
        private void UpdateRotate()
        {
            cube.transform.localRotation = Quaternion.Lerp(cube.transform.localRotation, _targetRot, _interpolant);
        }

        // キューブの回転　後ろ方向
        public void RotatePrevious()
        {
            // 拡大状態を戻しておく
            _targetScale = _defaultScale;
            cube.transform.localScale = new Vector3(_defaultScale, _defaultScale, _defaultScale);
            _isScaleUp = false;

            // 回転させる位置を指定する
            Vector3 targetEulerAngles = _targetRot.eulerAngles;
            targetEulerAngles.y = targetEulerAngles.y - _rotationalInterval;
            _targetRot = Quaternion.Euler(targetEulerAngles);
        }

        // キューブの回転　前方向
        public void RotateNext()
        {
            // 拡大状態を戻しておく
            _targetScale = _defaultScale;
            cube.transform.localScale = new Vector3(_defaultScale, _defaultScale, _defaultScale);
            _isScaleUp = false;

            // 回転させる位置を指定する
            Vector3 targetEulerAngles = _targetRot.eulerAngles;
            targetEulerAngles.y = targetEulerAngles.y + _rotationalInterval;
            _targetRot = Quaternion.Euler(targetEulerAngles);
        }

        // キューブの拡大
        private void UpdateScaleUp()
        {
            if (_scaleUpByTouchSensorXCoordinateEnable)
            {
                return;
            }
            if (Mathf.Abs(_targetScale - cube.transform.localScale.x) > 0.1f)
            {
                cube.transform.localScale = Vector3.Lerp(cube.transform.localScale, new Vector3(_targetScale, _targetScale, _targetScale), _interpolant * 1.2f);
            }
        }

        // キューブの拡大/縮小の切り替え
        public void ToggleScaleUp()
        {
            if (_isScaleUp)// 既に拡大状態なら、標準のサイズに戻す
            {
                Debug.Log("Default");
                _targetScale = _defaultScale;
                _isScaleUp = false;
            }
            else// まだ拡大状態でないなら、拡大する
            {
                Debug.Log("Max");
                _targetScale = _defaultScale * 2;
                _isScaleUp = true;
            }
        }
        // 現在の写真の拡大/縮小の切り替え（タッチセンサーの座標を元にする）
        private void UpdateScaleUpByTouchSensorXCoordinate()
        {
            if (!_scaleUpByTouchSensorXCoordinateEnable)
            {
                return;
            }
            _targetScale = _defaultScale * ((255 - glassesTouchSensorEventTrigger.XCoordinate)/255f + 0.5f);
            cube.transform.localScale = Vector3.Lerp(cube.transform.localScale, new Vector3(_targetScale, _targetScale, _targetScale), _interpolant * 3f);
        }

        // キューブの拡大/縮小の切り替え（タッチセンサーの座標を元にする）が有効かどうかを管理する
        public void ScaleUpByTouchSensorXCoordinateEnable(bool enable)
        {
            _scaleUpByTouchSensorXCoordinateEnable = enable;
        }

        // キューブの色変更
        public void SwitchColor()
        {
            // マテリアルがBlueMaterialならRedMaterialに変更、それ以外ならBlueMaterialに変更

            if (cube.GetComponent<Renderer>().material.color == Color.blue)
            {
                cube.GetComponent<Renderer>().material.color = Color.red;
            }
            else
            {
                cube.GetComponent<Renderer>().material.color = Color.blue;
            }
        }
    }
}
