﻿using UnityEngine;
using System;
using UnityEngine.UI;
using UnityEngine.Android;
using Qualcomm.Snapdragon.Spaces;

namespace NTTQONOQ.Android.MiRZA.Library.Samples.GlassesMicrophoneRecordingSample
{
    public class GlassesMicrophoneRecorder : MonoBehaviour
    {
        private AndroidJavaObject audioRecorderHandler;
        private bool isRecording = false;
        [SerializeField]
        private Text statusText;

        private void Start()
        {
            // マイクへのアクセス権限の要求を行う(DRF用)
            if (!Permission.HasUserAuthorizedPermission(Permission.Microphone))
            {
                var nativeXRSupportChecker = new AndroidJavaClass("com.qualcomm.snapdragon.spaces.serviceshelper.NativeXRSupportChecker");
                if (nativeXRSupportChecker.CallStatic<bool>("CanShowPermissions") || FeatureUseCheckUtility.IsFeatureEnabled(FeatureUseCheckUtility.SpacesFeature.Fusion))
                {
                    Permission.RequestUserPermission(Permission.Microphone);
                }
            }
        }

        private void InitializeJavaHandler()
        {
            // Java側のAudioRecorderHandlerクラスをインスタンス化
            audioRecorderHandler = new AndroidJavaObject("com.nttqonoq.mirza.recordlibrary.AudioRecorderHandler");
        }

        // 録音の開始
        public void StartRecording()
        {
            statusText.text = "Recording Status: Start recording";
            isRecording = true;

            InitializeJavaHandler();

            using (var unityPlayer = new AndroidJavaClass("com.unity3d.player.UnityPlayer"))
            {
                AndroidJavaObject activity = unityPlayer.GetStatic<AndroidJavaObject>("currentActivity");
                AndroidJavaObject context = activity.Call<AndroidJavaObject>("getApplicationContext");
                AndroidJavaObject audioManager = context.Call<AndroidJavaObject>("getSystemService", "audio");

                // AudioDeviceInfoの配列を取得
                AndroidJavaObject[] devices = audioManager.Call<AndroidJavaObject[]>("getDevices", 1); // GET_DEVICES_INPUTS

                AndroidJavaObject proxyDevice = null;

                foreach (var device in devices)
                {
                    int deviceType = device.Call<int>("getType");
                    if (deviceType == 20) // TYPE_IP
                    {
                        proxyDevice = device;
                        break;
                    }
                }

                if (proxyDevice != null)
                {
                    // 録音データの保存先ファイルを設定
                    string dateTime = DateTime.Now.ToString("yyyy_MM_dd_HH_mm_ss");
                    string fileName = $"audio_recording_{dateTime}.pcm";
                    string filePath = $"{Application.persistentDataPath}/{fileName}";

                    statusText.text = $"Recording Status: Start recording\nFile Path: {filePath}";

                    // Javaメソッドを呼び出し
                    audioRecorderHandler.Call("startRecordingWithDevice", proxyDevice, filePath);
                }
                else
                {
                    Debug.LogError("in-proxy deviceが見つかりません");
                }
            }
        }

        // 録音の停止
        public void StopRecording()
        {
            statusText.text = "Recording Status: Stop recording";
            isRecording = false;

            if (audioRecorderHandler != null)
            {
                audioRecorderHandler.Call("stopRecording");
                audioRecorderHandler.Dispose();
            }
        }

        // 録音の開始と停止の切り替え
        public void ToggleRecording()
        {
            if (isRecording)
            {
                StopRecording();
            }
            else
            {
                StartRecording();
            }
        }
    }
}
