using UnityEngine;

namespace NTTQONOQ.Android.MiRZA.Library.Samples.GPTImageAnalyzerSample
{
    public class ObjectCameraHeightSetter : MonoBehaviour
    {
        [SerializeField]
        private Transform cameraTransform;
        [SerializeField]
        private Transform objectTransform;

        [SerializeField]
        private bool onlyStart = true;
        private void Start()
        {
            SetHeight();
        }
        private void Update()
        {
            if (!onlyStart)
            {
                SetHeight();
            }
        }

        public void SetHeight()
        {
            if (cameraTransform != null && objectTransform != null)
            {
                objectTransform.position = new Vector3(objectTransform.position.x, cameraTransform.position.y, objectTransform.position.z);
            }
        }
    }
}