using Qualcomm.Snapdragon.Spaces.Samples;
using UnityEngine;

namespace NTTQONOQ.Android.MiRZA.Controller
{
    public class RayControlSwitcher : MonoBehaviour
    {
        public XRCameraPoseFollower cameraPoseFollower;

        public GameObject gyroPointerObject;

        public GameObject touchpadRayPointerObject;

        public void EnableGyroPointer()
        {
            cameraPoseFollower.TrackPosition = true;
            cameraPoseFollower.TrackRotation = true;

            gyroPointerObject.SetActive(true);
            touchpadRayPointerObject.SetActive(false);

            gyroPointerObject.GetComponentInChildren<GyroResetButton>()?.onClick.Invoke();
        }

        public void EnableTouchpadRayPointer()
        {
            cameraPoseFollower.TrackPosition = true;
            cameraPoseFollower.TrackRotation = false;

            gyroPointerObject.SetActive(false);
            touchpadRayPointerObject.SetActive(true);

            touchpadRayPointerObject.GetComponentInChildren<TouchpadRayDragHandler>()?.ResetPointer();
        }

    }
}