using UnityEngine;
using UnityEngine.XR.Interaction.Toolkit;

#if UNITY_6000_0_OR_NEWER // XR.Interaction.Toolkitが3.0.0以降のバージョンである場合 
using UnityEngine.XR.Interaction.Toolkit.Interactors;
using UnityEngine.XR.Interaction.Toolkit.Interactors.Visuals;
#endif

namespace NTTQONOQ.Android.MiRZA.Controller
{
    [RequireComponent(typeof(XRRayInteractor))]
    [RequireComponent(typeof(XRInteractorLineVisual))]
    public class RayColorController : MonoBehaviour
    {
        [SerializeField] private Gradient selectColor;
        [SerializeField] private bool isCustomValidColor;
        [SerializeField] private Gradient customValidColor;
        [SerializeField] private bool isCustomInvalidColor;
        [SerializeField] private Gradient customInvalidColor;

        
        private XRRayInteractor _interactor;
        private XRInteractorLineVisual _lineVisual;
        private Gradient _validBaseColor;
        private Gradient _invalidBaseColor;
        
        private void Awake()
        {
            _interactor = GetComponent<XRRayInteractor>();
            _lineVisual = GetComponent<XRInteractorLineVisual>();
        }
        
        private void Start()
        {
            if (_lineVisual is not null)
            {
                _validBaseColor = _lineVisual.validColorGradient;
                _invalidBaseColor = _lineVisual.invalidColorGradient;
                
                if (isCustomValidColor)
                    _lineVisual.validColorGradient = customValidColor;
                
                if (isCustomInvalidColor)
                    _lineVisual.invalidColorGradient = customInvalidColor;
            }
        }

        private void OnEnable()
        {
            if (_lineVisual is not null)
            {
                _interactor?.selectEntered.AddListener(OnSelectEntered);
                _interactor?.selectExited.AddListener(OnSelectExited);
            }
        }
        
        private void OnDisable()
        {
            _interactor?.selectEntered.RemoveListener(OnSelectEntered);
            _interactor?.selectExited.RemoveListener(OnSelectExited);
        }
        
        private void OnSelectEntered(SelectEnterEventArgs args)
        {
            _lineVisual.validColorGradient = selectColor;
        }
        
        private void OnSelectExited(SelectExitEventArgs args)
        {
            _lineVisual.validColorGradient = isCustomValidColor ? customValidColor : _validBaseColor;
            _lineVisual.invalidColorGradient = isCustomInvalidColor ? customInvalidColor : _invalidBaseColor;
        }
    }
}