using System.Reflection;
using UnityEngine;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Runtime
{
    public class PointerSimulator : MonoBehaviour
    {
#if UNITY_EDITOR
        [Tooltip("Assign the Pointer GameObject.")]
        [SerializeField] GameObject pointer = null;
        [SerializeField] float speed = 50.0f;
        private Vector2 eulerAngles = Vector2.zero;

        void Start()
        {
            if (pointer == null)
            {
                Debug.LogWarning("PointerSimulator: Pointer is not assigned. Please assign the Pointer GameObject.");
                return;
            }
        }

        void Update()
        {
            if (pointer == null) return;

            if (Input.GetKey(KeyCode.UpArrow))
            {
                eulerAngles.x -= speed * Time.deltaTime;
            }
            if (Input.GetKey(KeyCode.DownArrow))
            {
                eulerAngles.x += speed * Time.deltaTime;
            }
            if (Input.GetKey(KeyCode.RightArrow))
            {
                eulerAngles.y += speed * Time.deltaTime;
            }
            if (Input.GetKey(KeyCode.LeftArrow))
            {
                eulerAngles.y -= speed * Time.deltaTime;
            }

            pointer.transform.rotation = Quaternion.Euler(eulerAngles.x, eulerAngles.y, 0);
        }

        public GameObject Pointer => pointer; 

        public void SetPointer(GameObject pointer)
        {
            this.pointer = pointer;
            UnityEditor.EditorUtility.SetDirty(this);
        }
#endif
    }
}
