using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Rendering;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Runtime
{
    public class OverlayInspector : MonoBehaviour
    {
        [SerializeField] Camera _overlayCamera;

        void Start()
        {
            // var buff = new CommandBuffer();
            // buff.name = "OverlayInspector";

            var mesh = CreateMesh ();
            var material = new Material (Shader.Find ("Universal Render Pipeline/Unlit"));
            var buf = CreateCommandBuffer (mesh, material);

            _overlayCamera.AddCommandBuffer (CameraEvent.AfterSkybox, buf);
        }

        // Update is called once per frame
        void Update()
        {

        }

        private Mesh CreateMesh () {
            var mesh = new Mesh ();
            mesh.name = "TestMesh";
            var vertices = new List<Vector3> {
                new Vector3 (0.5f, 0.5f, 0),
                new Vector3 (-0.5f, 0.5f, 0),
                new Vector3 (0.5f, -0.5f, 0),
                new Vector3 (-0.5f, -0.5f, 0),
            };
            var triangles = new List<int> {
                1,
                0,
                2,
                1,
                2,
                3
            };
            mesh.SetVertices (vertices);
            mesh.SetTriangles (triangles, 0);
            return mesh;
        }

        private CommandBuffer CreateCommandBuffer (Mesh mesh, Material material) {
            var buf = new CommandBuffer ();

            buf.name = "My Command Buffer";

            buf.DrawMesh (
                mesh,
                Matrix4x4.TRS (new Vector3 (0, 0, 0), Quaternion.identity, Vector3.one),
                material
            );
            buf.DrawMesh (
                mesh,
                Matrix4x4.TRS (new Vector3 (2f, 0, 0), Quaternion.identity, Vector3.one),
                material
            );
            buf.DrawMesh (
                mesh,
                Matrix4x4.TRS (new Vector3 (-2f, 0, 0), Quaternion.identity, Vector3.one),
                material
            );

            return buf;
        }
    }
}
