﻿#if USING_MIRZA_SDK
using com.nttqonoq.devices.android.mirzalibrary;
using System;
using System.Reflection;
using UnityEngine;
using TouchType = com.nttqonoq.devices.android.mirzalibrary.TouchType;


namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Runtime
{
    public static class MirzaPluginUtility
    {
        public static readonly string ErrorMessage = "(Simulator)ErrorMessage";
        public static readonly string Version = "0.0.0";

        public static GlassStatus CreateGlassStatusInstance(ConnectionStatus bluetoothStatus, ConnectionStatus wifiStatus, bool spacesAvailable)
        {
            // GlassStatus のsetterがprivateなので、リフレクションを使ってインスタンスを生成する
            var status = Activator.CreateInstance(typeof(GlassStatus), true) as GlassStatus;
            if (status == null)
            {
                Debug.LogError("Failed to create GlassStatus instance.");
                return null;
            }
            Type type = typeof(GlassStatus);

            // BluetoothStatus を設定
            FieldInfo bluetoothField = type.GetField("<BluetoothStatus>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            bluetoothField?.SetValue(status, bluetoothStatus);

            // WifiStatus を設定
            FieldInfo wifiField = type.GetField("<WifiStatus>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            wifiField?.SetValue(status, wifiStatus);

            // SpacesAvailable を設定
            FieldInfo spacesField = type.GetField("<SpacesAvailable>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            spacesField?.SetValue(status, spacesAvailable);

            return status;
        }

        public static SwitchMicrophoneStatus SwitchMicrophoneStatus(MicMode wearingMicMode, MicMode frontMicMode, MixMode mixMode)
        {
            // SwitchMicrophoneStatus のsetterがprivateなので、リフレクションを使ってインスタンスを生成する
            var status = Activator.CreateInstance(typeof(SwitchMicrophoneStatus), true) as SwitchMicrophoneStatus;
            if (status == null)
            {
                Debug.LogError("Failed to create SwitchMicrophoneStatus instance.");
                return null;
            }
            Type type = typeof(SwitchMicrophoneStatus);

            // WearingMicMode を設定
            FieldInfo wearingMicModeField = type.GetField("<WearingMicMode>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            wearingMicModeField?.SetValue(status, wearingMicMode);

            // FrontMicMode を設定
            FieldInfo frontMicModeField = type.GetField("<FrontMicMode>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            frontMicModeField?.SetValue(status, frontMicMode);

            // MixMode を設定
            FieldInfo mixModeField = type.GetField("<MixMode>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            mixModeField?.SetValue(status, mixMode);

            return status;

        }


        public static GlassTouchGestureStatus CreateGlassTouchGestureStatusInstance(TouchType touchType, TouchOperation touchOperation, int xCoordinate, int yCoordinate, int movement)
        {
            // GlassTouchGestureStatus のsetterがprivateなので、リフレクションを使ってインスタンスを生成する
            var status = Activator.CreateInstance(typeof(GlassTouchGestureStatus), true) as GlassTouchGestureStatus;
            if (status == null)
            {
                Debug.LogError("Failed to create GlassTouchGestureStatus instance.");
                return null;
            }
            Type type = typeof(GlassTouchGestureStatus);

            // TouchType を設定
            FieldInfo typeField = type.GetField("<Type>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            typeField?.SetValue(status, touchType);

            // Operation を設定
            FieldInfo operationField = type.GetField("<Operation>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            operationField?.SetValue(status, touchOperation);

            // XCoordinate を設定
            FieldInfo xCoordinateField = type.GetField("<XCoordinate>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            xCoordinateField?.SetValue(status, xCoordinate);

            // YCoordinate を設定
            FieldInfo yCoordinateField = type.GetField("<YCoordinate>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            yCoordinateField?.SetValue(status, yCoordinate);

            // Movement を設定
            FieldInfo movementField = type.GetField("<Movement>k__BackingField", BindingFlags.NonPublic | BindingFlags.Instance);
            movementField?.SetValue(status, movement);
            return status;
        }
    }
}
#endif