using Unity.XR.CoreUtils;
using UnityEngine;
using UnityEngine.UI;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Runtime
{
    public class DebugConsole: MonoBehaviour
    {
        [SerializeField] private bool _enableMirzaMonitoring = true;

        [SerializeField] private GameObject _hmdPrefab;

        [SerializeField] private Button _toggleHUDButton;

        [SerializeField] private float _hudUpdateInterval = 1.0f;

        [SerializeField] private int _fpsBufferSize = 32;

        private DebugHUD _debugHUD;

        private void Start()
        {
            _toggleHUDButton.onClick.AddListener(OnButtonClick);
        }

        private void SetupDebugHUD()
        {
            var xrOrigin = FindFirstObjectByType<XROrigin>(FindObjectsInactive.Include);
            if (xrOrigin == null)
            {
                Debug.LogWarning("XROrigin not found.");
                return;
            }

            var hudCamera = xrOrigin.Camera;
            if (hudCamera == null)
            {
                Debug.LogWarning("Camera not found.");
                return;
            }

            _debugHUD = Instantiate(_hmdPrefab).GetComponent<DebugHUD>();
            _debugHUD.EnableMirzaMonitoring = _enableMirzaMonitoring;
            _debugHUD.transform.SetParent(hudCamera.transform, false);
        }

        private void OnDestroy()
        {
            _toggleHUDButton.onClick.RemoveListener(OnButtonClick);
        }

        private void OnButtonClick()
        {
            if (_debugHUD == null)
            {
                SetupDebugHUD();
            }

            if (_debugHUD != null)
            {
                _debugHUD.ToggleDisplayMode();
                _debugHUD.FpsBufferSize = _fpsBufferSize;
                _debugHUD.UpdateInterval = _hudUpdateInterval;
                //Debug.Log(mode.ToString());
            }
        }
    }
}