﻿using System;
using UnityEditor;
using UnityEngine;
using Object = UnityEngine.Object;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public static class XRInteractionToolkitAssemblyUtility
    {
        public static bool TryGetXRDeviceSimulatorEnabled(out bool result)
        {
            result = false;

            string assetPath = "XRDeviceSimulatorSettings";
            Object settings = Resources.Load<Object>(assetPath);

            if (settings == null)
            {
                return false;
            }

            var succeed = AssemblyUtility.TryGetFieldValueFromAssembly("Unity.XR.Interaction.Toolkit", "UnityEngine.XR.Interaction.Toolkit.Inputs.Simulation.XRDeviceSimulatorSettings", "m_AutomaticallyInstantiateSimulatorPrefab", settings, out var field);
            if (!succeed)
            {
                return false;
            }

            if (field.GetType() != typeof(bool))
            {
                return false;
            }

            result = (bool)field;
            return true;
        }

        public static bool TryGetConfiguredInputActionManager(out MonoBehaviour result)
        {
            result = null;
            var targetName = Constants.DefaultQCHTInputActionsName;
            var targets = Utility.FindComponentsByName("InputActionManager");

            bool succeed = false;
            foreach (var target in targets)
            {
                succeed = AssemblyUtility.TryGetFieldValueFromAssembly("Unity.XR.Interaction.Toolkit", "UnityEngine.XR.Interaction.Toolkit.Inputs.InputActionManager", "m_ActionAssets", target, out var field);
                if (!succeed || field == null)
                {
                    continue;
                }
                var listType = field.GetType();
                if (!listType.IsGenericType || listType.GetGenericTypeDefinition() != typeof(System.Collections.Generic.List<>))
                {
                    continue;
                }
                var enumerable = field as System.Collections.IEnumerable;
                if (enumerable == null)
                {
                    continue;
                }

                foreach (var obj in enumerable)
                {
                    if (obj == null)
                    {
                        continue;
                    }
                    var nameProperty = obj.GetType().GetProperty("name", System.Reflection.BindingFlags.Public | System.Reflection.BindingFlags.Instance);
                    if (nameProperty == null)
                    {
                        continue;
                    }

                    var name = nameProperty.GetValue(obj) as string;
                    if (string.IsNullOrEmpty(name))
                    {
                        continue;
                    }
                    if (name == targetName)
                    {
                        result = target;
                        break;
                    }
                }
                if (result != null)
                {
                    break;
                }
            }
            return result != null;
        }

        public static bool TrySetDefaultQCHTInputActions(Component inputActionManager)
        {
            var succeed = AssemblyUtility.TryGetFieldValueFromAssembly(
                "Unity.XR.Interaction.Toolkit",
                "UnityEngine.XR.Interaction.Toolkit.Inputs.InputActionManager",
                "m_ActionAssets",
                inputActionManager,
                out var field
            );

            if (!succeed)
            {
                return false;
            }

            if (field == null)
            {
                var inputActionAssetType = Type.GetType("UnityEngine.InputSystem.InputActionAsset, Unity.InputSystem");
                if (inputActionAssetType == null)
                {
                    return false;
                }
                var type = typeof(System.Collections.Generic.List<>).MakeGenericType(inputActionAssetType);
                if (type == null)
                {
                    return false;
                }
                field = Activator.CreateInstance(type);

                var setFieldSucceed = AssemblyUtility.TrySetFieldValueFromAssembly(
                    "Unity.XR.Interaction.Toolkit",
                    "UnityEngine.XR.Interaction.Toolkit.Inputs.InputActionManager",
                    "m_ActionAssets",
                    inputActionManager,
                    field
                );
                if (!setFieldSucceed)
                {
                    return false;
                }
            }

            var listType = field.GetType();
            if (!listType.IsGenericType || listType.GetGenericTypeDefinition() != typeof(System.Collections.Generic.List<>))
            {
                return false;
            }
            var elementType = listType.GetGenericArguments()[0];

            try
            {
                if (AssemblyUtility.TryFindAssetPath(Constants.QCHTBasePath, Constants.DefaultQCHTInputActionsSearchPattern, out var assetPath))
                {
                    var asset = AssetDatabase.LoadAssetAtPath(assetPath, elementType);
                    if (asset == null)
                    {
                        return false;
                    }

                    var addMethod = listType.GetMethod("Add");
                    if (addMethod == null)
                    {
                        return false;
                    }

                    addMethod.Invoke(field, new[] { asset });
                    return true;
                }
            }
            catch (Exception)
            {
                return false;
            }
            return false;
        }

        public static void AddTrackedDeviceGraphicRaycaster(Canvas canvas)
        {
            var assembly = AssemblyUtility.FindAssemblyByName("Unity.XR.Interaction.Toolkit");
            var trackedDeviceGraphicRaycasterType =assembly.GetType("UnityEngine.XR.Interaction.Toolkit.UI.TrackedDeviceGraphicRaycaster");
            if (trackedDeviceGraphicRaycasterType == null)
            {
                Debug.LogError("TrackedDeviceGraphicRaycaster type not found.");
                return;
            }
            var raycaster = canvas.gameObject.GetComponent(trackedDeviceGraphicRaycasterType);
            if (raycaster == null)
            {
                AssemblyUtility.AddComponentToGameObject(
                    canvas.gameObject, 
                    "Unity.XR.Interaction.Toolkit",
                    "UnityEngine.XR.Interaction.Toolkit.UI.TrackedDeviceGraphicRaycaster",
                    true
                );
            }
        }
    }
}
