using System;
using UnityEngine;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    /// <summary>
    /// Validation結果を格納するクラス
    /// nullの場合は問題なし
    /// エラーの場合はエラーメッセージを格納
    /// </summary>
    [Serializable]
    public class ValidationReport
    {
        public string CreateDate;

        public ProjectParams ProjectParams = new();

        public SceneParams SceneParams = new();

        public SimulatorParams SimulatorParams = new();

        public TemplatesParams TemplatesParams = new();

        public SamplesParams SamplesParams = new();

        public DebugParams DebugParams = new();

        public string ToJson()
        {
            return JsonUtility.ToJson(this);
        }

        public PackageParam GetRequiredPackageInfo(string packageName)
        {
            return ProjectParams.Packages.Find(x => x.Name == packageName);
        }

        public AssetParam GetRequiredAssetInfo(string packageName, string assetName)
        {
            return ProjectParams.Assets.Find(x => x.Name == assetName && x.PackageName == packageName);
        }
    }
}