using UnityEditor;
using UnityEngine.UIElements;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public class TemplatesPanel: BasePanel
    {
        public TemplatesPanel(VisualTreeAsset visualTreeAsset, ConfigurationWindow window) : base(visualTreeAsset, window)
        {
            AddOpenLinkButtonClickListener("OpenTemplatesManualButton", "setup/mirza-sdk/categories/templates");

            AddSampleImportButtonClickListener("BasicTemplate", () =>
            {
                var param = Report.GetRequiredPackageInfo(Validator.ConfigToolPackageName);
                var displayName = "Basic Template";
                if (!ConfirmSampleOverride(displayName, param)) return;
                SampleImporter.ImportSample(displayName, param);
                OpenAndSelectScene($"Assets/Samples/MiRZA Configuration Tool/{param.ActualVersion}/{displayName}/BasicTemplate.unity");
                Window.Validate();
            });

            AddSampleImportButtonClickListener("HandTrackingTemplate", () =>
            {
                var param = Report.GetRequiredPackageInfo(Validator.ConfigToolPackageName);
                var displayName = "Hand Tracking Template";
                if (!ConfirmSampleOverride(displayName, param)) return;
                SampleImporter.ImportSample(displayName, param);
                OpenAndSelectScene($"Assets/Samples/MiRZA Configuration Tool/{param.ActualVersion}/{displayName}/HandTrackingTemplate.unity");
                Window.Validate();
            });

            AddButtonClickListener("OpenQCHTSamplesButton", () =>
            {
                var info = Report.GetRequiredPackageInfo(Validator.InteractionsPackageName);
                if (info is not { Exists: true })
                {
                    EditorUtility.DisplayDialog("Error", "QCHT Unity Interactions package not found.", "OK");
                    return;
                }
                UnityEditor.PackageManager.UI.Window.Open(Validator.InteractionsPackageName);
                Utility.OpenSamplesTabInPackageManagerWindow();
            });
        }

        public override void RefreshPanel()
        {
            var param = Report.GetRequiredPackageInfo(Validator.ConfigToolPackageName);
            RefleshSampleImportButton(PanelParent.Q<VisualElement>("BasicTemplate").Q<Button>("ImportButton"), "Basic Template", param);
            RefleshSampleImportButton(PanelParent.Q<VisualElement>("HandTrackingTemplate").Q<Button>("ImportButton"), "Hand Tracking Template", param);

            var spacesSdkParam = Report.GetRequiredPackageInfo(Validator.SpacesPackageName);
            var spacesSdkCoreSamplesParam = Report.GetRequiredAssetInfo(Validator.SpacesPackageName, "Core Samples");
            var spacesSdkFusionSamplesParam = Report.GetRequiredAssetInfo(Validator.SpacesPackageName, "Fusion Samples");
            var isQnqControllerFolderExist = Utility.IsQnqControllerFolderExist();

            UpdateValueLabel("BasicTemplate_SpacesSdkVersionLabel", spacesSdkParam, true);
            UpdateValueLabel("BasicTemplate_SpacesSdkCoreSamplesLabel", spacesSdkCoreSamplesParam, true);
            UpdateValueLabel("BasicTemplate_SpacesSdkFusionSamplesLabel", spacesSdkFusionSamplesParam, true);
            UpdateBoolValueLabel("BasicTemplate_DualRenderFusionControllerLabel", isQnqControllerFolderExist, true);

            UpdateValueLabel("HandTrackingTemplate_SpacesSdkVersionLabel", spacesSdkParam, true);
            UpdateValueLabel("HandTrackingTemplate_SpacesSdkCoreSamplesLabel", spacesSdkCoreSamplesParam, true);
            UpdateValueLabel("HandTrackingTemplate_SpacesSdkFusionSamplesLabel", spacesSdkFusionSamplesParam, true);
            UpdateValueLabel("QchtSdkVersionLabel", Report.GetRequiredPackageInfo(Validator.InteractionsPackageName), true);
            UpdateValueLabel("QchtSdkCoreAssetsLabel", Report.GetRequiredAssetInfo(Validator.InteractionsPackageName, "Core Assets"), true);
            UpdateBoolValueLabel("HandTrackingTemplate_DualRenderFusionControllerLabel", isQnqControllerFolderExist, true);
            UpdateValueLabelByName("HandTrackingFeatureLabel", Report.TemplatesParams.HandTrackingFeatureEnabled, true);
        }
    }
}