﻿using System;
using UnityEditor;
using UnityEditor.Compilation;
using UnityEngine;
using UnityEngine.UIElements;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public class SamplesPanel : BasePanel
    {
        public SamplesPanel(VisualTreeAsset visualTreeAsset, ConfigurationWindow window) : base(visualTreeAsset, window)
        {
            AddOpenLinkButtonClickListener("OpenSamplesManualButton", "setup/mirza-sdk/categories/samples");

            AddSampleImportButtonClickListener("GlassesMicrophoneRecording", () =>
            {
                var param = Report.GetRequiredPackageInfo(Validator.ConfigToolPackageName);
                var displayName = "Glasses Microphone Recording Sample";
                if (!ConfirmSampleOverride(displayName, param)) return;
                SampleImporter.ImportSample(displayName, param);
                AssetUtility.OpenAndSelectScene($"Assets/Samples/MiRZA Configuration Tool/{param.ActualVersion}/{displayName}/Glasses Microphone Recorder DRF.unity");
                Window.Validate();
            });

            AddOpenLinkButtonClickListener("OpenGlassesMicrophoneRecordingSampleGuideButton",
                "samples/samples-qonoq/unity-packages/mirza-library/glasses-microphone-recording");

            AddSampleImportButtonClickListener("MRModeSwitcher", () =>
            {
                var param = Report.GetRequiredPackageInfo(Validator.ConfigToolPackageName);
                var displayName = "MR Mode Switcher Sample";
                if (!ConfirmSampleOverride(displayName, param)) return;
                SampleImporter.ImportSample(displayName, param);
                AssetUtility.OpenAndSelectScene($"Assets/Samples/MiRZA Configuration Tool/{param.ActualVersion}/{displayName}/MR Mode Auto Switcher DRF.unity");
                Window.Validate();
            });

            AddOpenLinkButtonClickListener("OpenMRModeSwitcherSampleGuideButton",
                "samples/samples-qonoq/unity-packages/mirza-library/mr-mode-switcher");

            AddSampleImportButtonClickListener("TouchSensor", () =>
            {
                var param = Report.GetRequiredPackageInfo(Validator.ConfigToolPackageName);
                var displayName = "Touch Sensor Sample";
                if (!ConfirmSampleOverride(displayName, param)) return;
                SampleImporter.ImportSample(displayName, param);
                AssetUtility.OpenAndSelectScene($"Assets/Samples/MiRZA Configuration Tool/{param.ActualVersion}/{displayName}/Touch Sensor.unity");
                Window.Validate();
            });

            AddOpenLinkButtonClickListener("TouchSensorSampleGuideButton",
                "tips/how-to-use-the-glasses-touch-sensor/");

            AddSampleImportButtonClickListener("GPTImageAnalyzer", () =>
            {
                var param = Report.GetRequiredPackageInfo(Validator.ConfigToolPackageName);
                var displayName = "GPT Image Analyzer Sample";
                if (!ConfirmSampleOverride(displayName, param)) return;
                SampleImporter.ImportSample(displayName, param);
                AssetUtility.OpenAndSelectScene($"Assets/Samples/MiRZA Configuration Tool/{param.ActualVersion}/{displayName}/GPT Image Analyze Speaker.unity");
                Window.Validate();
            });

            AddOpenLinkButtonClickListener("OpenGPTImageAnalyzerSampleGuideButton",
                "samples/samples-qonoq/unity-packages/function/image-recognition");

            AddButtonClickListener("EnableAllowUnsafeCodeButton", () =>
            {
                var param = ValidationUtility.GetAllowUnsafeCode();
                if (!param.Exists)
                {
                    EditorUtility.DisplayDialog("Error", "Failed to get Allow Unsafe Code.", "OK");
                    return;
                }

                try
                {
                    Utility.SetAllowUnsafeCode(true);
                }
                catch (Exception e)
                {
                    Debug.LogError("Failed to enable Allow Unsafe Code: " + e.Message);
                    EditorUtility.DisplayDialog("Error", "Failed to enable Allow Unsafe Code.", "OK");
                    return;
                }

                Window.Validate();
                CompilationPipeline.RequestScriptCompilation();
            });

            AddButtonClickListener("SelectButton", () =>
            {
                var target = Utility.FindGameObjectByName(Constants.ImageAnalyzeSpeakerGameObjectName);
                if (target == null)
                {
                    EditorUtility.DisplayDialog("Error", "Image Analyze Speaker not found.", "OK");
                    return;
                }
                Selection.activeGameObject = target;
            });

            AddButtonClickListener("OpenMirzaLibrarySamplesButton", () =>
            {
                var info = Report.GetRequiredPackageInfo(Validator.MirzaLibraryPackageName);
                if (info is not { Exists: true })
                {
                    EditorUtility.DisplayDialog("Error", "MiRZA Library package not found.", "OK");
                    return;
                }
                UnityEditor.PackageManager.UI.Window.Open(Validator.MirzaLibraryPackageName);
                Utility.OpenSamplesTabInPackageManagerWindow();
            });
        }

        public override void RefreshPanel()
        {
            var param = Report.GetRequiredPackageInfo(Validator.ConfigToolPackageName);
            var spacesSdkParam = Report.GetRequiredPackageInfo(Validator.SpacesPackageName);
            var spacesSdkCoreSamplesParam = Report.GetRequiredAssetInfo(Validator.SpacesPackageName, "Core Samples");
            var spacesSdkFusionSamplesParam = Report.GetRequiredAssetInfo(Validator.SpacesPackageName, "Fusion Samples");
            var mirzaLibrarySampleParam = Report.GetRequiredAssetInfo(Validator.MirzaLibraryPackageName, "Sample");
            var newtonsoftJsonParam = Report.GetRequiredPackageInfo(Validator.NewtonsoftJsonPackageName);
            var isQnqControllerFolderExist = Utility.IsQnqControllerFolderExist();

            RefleshSampleImportButton(PanelParent.Q<VisualElement>("GlassesMicrophoneRecording").Q<Button>("ImportButton"), "Glasses Microphone Recording Sample", param);
            RefleshSampleImportButton(PanelParent.Q<VisualElement>("MRModeSwitcher").Q<Button>("ImportButton"), "MR Mode Switcher Sample", param);
            RefleshSampleImportButton(PanelParent.Q<VisualElement>("TouchSensor").Q<Button>("ImportButton"), "Touch Sensor Sample", param);
            RefleshSampleImportButton(PanelParent.Q<VisualElement>("GPTImageAnalyzer").Q<Button>("ImportButton"), "GPT Image Analyzer Sample", param);

            UpdateValueLabel("GlassesMicrophoneRecording_SpacesSdkVersionLabel", spacesSdkParam, true);
            UpdateValueLabel("GlassesMicrophoneRecording_SpacesSdkCoreSamplesLabel", spacesSdkCoreSamplesParam, true);
            UpdateValueLabel("GlassesMicrophoneRecording_SpacesSdkFusionSamplesLabel", spacesSdkFusionSamplesParam, true);
            UpdateValueLabel("GlassesMicrophoneRecording_MirzaLibraryVersionLabel",
                Report.GetRequiredPackageInfo(Validator.MirzaLibraryPackageName), true);
            UpdateValueLabel("GlassesMicrophoneRecording_MirzaLibrarySampleLabel", mirzaLibrarySampleParam, true);

            UpdateValueLabel("MRModeSwitcher_SpacesSdkVersionLabel", spacesSdkParam, true);
            UpdateValueLabel("MRModeSwitcher_SpacesSdkCoreSamplesLabel", spacesSdkCoreSamplesParam, true);
            UpdateValueLabel("MRModeSwitcher_SpacesSdkFusionSamplesLabel", spacesSdkFusionSamplesParam, true);
            UpdateValueLabel("MRModeSwitcher_MirzaLibraryVersionLabel",
                Report.GetRequiredPackageInfo(Validator.MirzaLibraryPackageName), true);
            UpdateBoolValueLabel("MRModeSwitcher_DualRenderFusionControllerLabel", isQnqControllerFolderExist, true);

            UpdateValueLabel("TouchSensor_SpacesSdkVersionLabel", spacesSdkParam, true);
            UpdateValueLabel("TouchSensor_SpacesSdkCoreSamplesLabel", spacesSdkCoreSamplesParam, true);
            UpdateValueLabel("TouchSensor_SpacesSdkFusionSamplesLabel", spacesSdkFusionSamplesParam, true);
            UpdateValueLabel("TouchSensor_MirzaLibraryVersionLabel",
                Report.GetRequiredPackageInfo(Validator.MirzaLibraryPackageName), true);
            UpdateBoolValueLabel("TouchSensor_DualRenderFusionControllerLabel", isQnqControllerFolderExist, true);

            UpdateValueLabel("GPTImageAnalyzer_SpacesSdkVersionLabel", spacesSdkParam, true);
            UpdateValueLabel("GPTImageAnalyzer_SpacesSdkCoreSamplesLabel", spacesSdkCoreSamplesParam, true);
            UpdateValueLabel("GPTImageAnalyzer_SpacesSdkFusionSamplesLabel", spacesSdkFusionSamplesParam, true);
            UpdateValueLabel("GPTImageAnalyzer_MirzaLibraryVersionLabel",
                Report.GetRequiredPackageInfo(Validator.MirzaLibraryPackageName), true);
            UpdateBoolValueLabel("GPTImageAnalyzer_DualRenderFusionControllerLabel", isQnqControllerFolderExist, true);
            bool isAllowedUnsafeCode = Report.SamplesParams.AllowUnsafeCode.Exists &&
                                       Report.SamplesParams.AllowUnsafeCode.Actual == "True";
            PanelParent.Q<Button>("EnableAllowUnsafeCodeButton").text =
                isAllowedUnsafeCode ? "Enabled" : "Enable";
            PanelParent.Q<Button>("EnableAllowUnsafeCodeButton").SetEnabled(!isAllowedUnsafeCode);

            UpdateValueLabelByName("GPTImageAnalyzer_OpenAIAPIKeyLabel", Report.SamplesParams.OpenAIAPIKeyConfigured, true);
            UpdateValueLabelByName("GPTImageAnalyzer_GCPAPIKeyLabel", Report.SamplesParams.GCPAPIKeyConfigured);
            UpdateValueLabel("GPTImageAnalyzer_NewtonsoftJsonVersionLabel", newtonsoftJsonParam, true);
            UpdateValueLabelByName("CameraAccessFeatureLabel", Report.SamplesParams.CameraAccessFeatureEnabled, true);
        }
    }
}