using System.IO;
using UnityEditor.PackageManager.UI;
using UnityEngine;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public static class SampleImporter
    {
        public static void ImportSample(string displayName, PackageParam param)
        {
            var samples = Sample.FindByPackage(param.Name, param.ActualVersion);
            foreach (var sample in samples)
            {
                if (sample.displayName == displayName)
                {
                    sample.Import(Sample.ImportOptions.OverridePreviousImports);
                    return;
                }
            }
        }

        public static bool IsSampleImported(string displayName, PackageParam param, out bool isCurrentVersionSample)
        {
            isCurrentVersionSample = false;

            var samples = Sample.FindByPackage(param.Name, param.ActualVersion);
            foreach (var sample in samples)
            {
                if (sample.displayName == displayName)
                {
                    if (sample.isImported)
                    {
                        isCurrentVersionSample = true;
                        return true;
                    }
                }
            }
            
            if (string.IsNullOrEmpty(param.DisplayName)) return false;

            var samplePath = Path.Combine(Application.dataPath, "Samples");
            if (Directory.Exists(samplePath))
            {
                var packagePath = Path.Combine(samplePath, param.DisplayName);
                if (Directory.Exists(packagePath))
                {
                    var versionDirs = Directory.GetDirectories(packagePath);
                    foreach (var versionDir in versionDirs)
                    {
                        var versionDirName = Path.GetFileName(versionDir);
                        var versionParts = versionDirName.Split('.');
                        if (versionParts.Length == 3 && int.TryParse(versionParts[0], out _) && int.TryParse(versionParts[1], out _) && int.TryParse(versionParts[2], out _))
                        {
                            var versionDirPath = Path.Combine(packagePath, versionDirName);
                            var dirs = Directory.GetDirectories(versionDirPath);
                            foreach (var dir in dirs)
                            {
                                var dirName = Path.GetFileName(dir);
                                if (dirName == displayName)
                                {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
            return false;
        }
    }
}