using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public static class QCHTAssemblyUtility
    {
        public static bool TryGetHandTrackingSimulationEnabled(out bool result)
        {
            result = false;

#if USING_QCHT_4_1_13_OR_NEWER
            var assetPath = "XRHandTrackingSimulationSettings";
#else
            var assetPath = "HandTrackingSimulationSettings";
#endif

            Object settings = Resources.Load<Object>(assetPath);

            if (settings == null)
            {
                return false;
            }

#if USING_QCHT_4_1_13_OR_NEWER
            var typeName = "QCHT.Interactions.Core.XRHandTrackingSimulationSettings";
#else
            var typeName = "QCHT.Interactions.Core.HandTrackingSimulationSettings";
#endif

            var succeed = AssemblyUtility.TryGetFieldValueFromAssembly("QCHT.Interactions", typeName, "enabled", settings, out var field);
            if (!succeed)
            {
                return false;
            }

            if (field.GetType() != typeof(bool))
            {
                return false;
            }

            result = (bool)field;
            return true;
        }
    }
}
