﻿using System.IO;
using UnityEditor;
using UnityEngine.UIElements;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public class OtherPanel : BasePanel
    {
        public OtherPanel(VisualTreeAsset visualTreeAsset, ConfigurationWindow window) : base(visualTreeAsset, window)
        {
            AddOpenLinkButtonClickListener("OpenOtherManualButton", "setup/mirza-sdk/categories/other");

            AddButtonClickListener("ExportValidationInfoButton", () =>
            {
                if (Report == null)
                {
                    return;
                }
                var data = Report.ToJson();
                var path = EditorUtility.SaveFilePanel("Save Validation Info", "", "validation_info.json", "json");
                if (!string.IsNullOrEmpty(path))
                {
                    File.WriteAllText(path, data);
                }
            });

            AddButtonClickListener("CleanEditorPrefsDataButton", () =>
            {
                UnityConfigurationTool.CleanEditorPrefsData();
                EditorUtility.DisplayDialog("MiRZA Configuration Tool",
    "EditorPrefs data added by MiRZA Configuration Tool is deleted.", "OK");
            });
        }

        public override void RefreshPanel()
        {
            UpdateValueLabel("MCTVersionLabel", Report.GetRequiredPackageInfo(Validator.ConfigToolPackageName));
        }
    }
}