﻿#if USING_MIRZA_SDK && UNITY_EDITOR
using UnityEditor;
using UnityEngine;
using com.nttqonoq.devices.android.mirzalibrary;
using System;
using TouchType = com.nttqonoq.devices.android.mirzalibrary.TouchType;
using NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Runtime;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    [CustomEditor(typeof(MirzaDeviceEventSimulator))]
    public class MirzaDeviceEventSimulatorEditor : UnityEditor.Editor
    {
        private SerializedProperty _selectedServiceStateProperty;
        private SerializedProperty _selectedBluetoothGlassStatusProperty;
        private SerializedProperty _selectedWifiGlassStatusProperty;
        private SerializedProperty _selectedSpacesAvailableProperty;
        private SerializedProperty _batteryLevelProperty;
        private SerializedProperty _selectedSpacesModeStatusProperty;
        private SerializedProperty _selectedDisplayStatusProperty;
        private SerializedProperty _selectedTouchTypeIndexProperty;
        private SerializedProperty _selectedTouchOperationIndexProperty;
        private SerializedProperty _xCoordinateProperty;
        private SerializedProperty _yCoordinateProperty;
        private SerializedProperty _movementProperty;
        private SerializedProperty _stateProperty;
        private SerializedProperty _versionConsistencyResultProperty;
        private SerializedProperty _chargeStatusProperty;

        private GUIStyle _titleStyle;
        private bool isFirstTime = true;

        private void OnEnable()
        {
            _selectedServiceStateProperty = serializedObject.FindProperty("selectedStateIndex");
            _selectedBluetoothGlassStatusProperty = serializedObject.FindProperty("selectedBluetoothStatusIndex");
            _selectedWifiGlassStatusProperty = serializedObject.FindProperty("selectedWifiStatusIndex");
            _selectedSpacesAvailableProperty = serializedObject.FindProperty("spacesAvailable");
            _batteryLevelProperty = serializedObject.FindProperty("batteryLevel");
            _selectedSpacesModeStatusProperty = serializedObject.FindProperty("selectedSpacesModeStatusIndex");
            _selectedDisplayStatusProperty = serializedObject.FindProperty("selectedDisplayStatusIndex");
            _selectedTouchTypeIndexProperty = serializedObject.FindProperty("selectedTouchTypeIndex");
            _selectedTouchOperationIndexProperty = serializedObject.FindProperty("selectedTouchOperationIndex");
            _xCoordinateProperty = serializedObject.FindProperty("xCoordinate");
            _yCoordinateProperty = serializedObject.FindProperty("yCoordinate");
            _movementProperty = serializedObject.FindProperty("movement");
            _stateProperty = serializedObject.FindProperty("stateIndex");
            _versionConsistencyResultProperty = serializedObject.FindProperty("versionConsistencyResultData");
            _chargeStatusProperty = serializedObject.FindProperty("chargeStatusIndex");
        }

        public override void OnInspectorGUI()
        {
            MirzaDeviceEventSimulator simulator = (MirzaDeviceEventSimulator)target;
            serializedObject.Update();

            _titleStyle = new GUIStyle(EditorStyles.label);
            _titleStyle.fontSize = 20;

            GUILayout.Label("Parameters and Invoke Events", _titleStyle);
            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.BeginVertical();
            GUILayout.Label("Service Status Event Handler", EditorStyles.boldLabel);
            GUILayout.BeginHorizontal();
            GUILayout.Label("ServiceStatus");
            GUILayout.FlexibleSpace();
            _selectedServiceStateProperty.intValue = EditorGUILayout.Popup(_selectedServiceStateProperty.intValue, simulator._serviceStateOptions, GUILayout.Width(100));
            GUILayout.EndHorizontal();
            EditorGUI.BeginDisabledGroup(!EditorApplication.isPlaying);
            if (GUILayout.Button("Invoke OnServiceStateChanged"))
            {
                ServiceState state = (ServiceState)Enum.Parse(typeof(ServiceState), simulator._serviceStateOptions[_selectedServiceStateProperty.intValue]);
                simulator.HandleServiceStateChanged(state);
            }
            EditorGUI.EndDisabledGroup();

            GUILayout.EndVertical();

            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.BeginVertical();
            GUILayout.Label("Glass Status Event Handler", EditorStyles.boldLabel);
            GUILayout.BeginHorizontal();
            GUILayout.Label("BluetoothStatus");
            GUILayout.FlexibleSpace();
            _selectedBluetoothGlassStatusProperty.intValue = EditorGUILayout.Popup(_selectedBluetoothGlassStatusProperty.intValue, simulator._connectionStatusOptions, GUILayout.Width(100));
            GUILayout.EndHorizontal();

            GUILayout.BeginHorizontal();
            GUILayout.Label("WifiStatus");
            GUILayout.FlexibleSpace();
            _selectedWifiGlassStatusProperty.intValue = EditorGUILayout.Popup(_selectedWifiGlassStatusProperty.intValue, simulator._connectionStatusOptions, GUILayout.Width(100));
            GUILayout.EndHorizontal();

            GUILayout.BeginHorizontal();
            GUILayout.Label("SpacesAvailable");
            GUILayout.FlexibleSpace();
            _selectedSpacesAvailableProperty.boolValue = EditorGUILayout.Toggle(_selectedSpacesAvailableProperty.boolValue, GUILayout.Width(20));
            GUILayout.EndHorizontal();

            EditorGUI.BeginDisabledGroup(!EditorApplication.isPlaying);
            if (GUILayout.Button("Invoke OnGlassStatusChaged"))
            {
                simulator.HandleGlassStatusChanged();
            }
            EditorGUI.EndDisabledGroup();
            GUILayout.EndVertical();

            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.BeginVertical();
            GUILayout.Label("Battery Level Event Handler", EditorStyles.boldLabel);
            GUILayout.BeginHorizontal();
            GUILayout.Label("Battery Level");
            GUILayout.FlexibleSpace();
            _batteryLevelProperty.intValue = EditorGUILayout.IntSlider(_batteryLevelProperty.intValue, 0, 100);
            GUILayout.EndHorizontal();

            EditorGUI.BeginDisabledGroup(!EditorApplication.isPlaying);
            if (GUILayout.Button("Invoke OnBatteryLevelChanged"))
            {
                simulator.HandleBatteryLevelChanged(_batteryLevelProperty.intValue);
            }
            EditorGUI.EndDisabledGroup();
            GUILayout.EndVertical();

            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.BeginVertical();
            GUILayout.Label("Spaces Mode Event Handler", EditorStyles.boldLabel);
            GUILayout.BeginHorizontal();
            GUILayout.Label("SpacesModeStatus");
            GUILayout.FlexibleSpace();
            _selectedSpacesModeStatusProperty.intValue = EditorGUILayout.Popup(_selectedSpacesModeStatusProperty.intValue, simulator._spacesModeStatusOptions, GUILayout.Width(100));
            GUILayout.EndHorizontal();

            EditorGUI.BeginDisabledGroup(!EditorApplication.isPlaying);
            if (GUILayout.Button("Invoke OnSpacesModeStatusChanged"))
            {
                simulator.HandleSpacesModeStatusChanged();
            }
            EditorGUI.EndDisabledGroup();
            GUILayout.EndVertical();

            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.BeginVertical();
            GUILayout.Label("Display Status Event Handler", EditorStyles.boldLabel);
            GUILayout.BeginHorizontal();
            GUILayout.Label("DisplayStatus");
            GUILayout.FlexibleSpace();
            _selectedDisplayStatusProperty.intValue = EditorGUILayout.Popup(_selectedDisplayStatusProperty.intValue, simulator._displayStatusOptions, GUILayout.Width(100));
            GUILayout.EndHorizontal();

            EditorGUI.BeginDisabledGroup(!EditorApplication.isPlaying);
            if (GUILayout.Button("Invoke OnDisplayStatusChanged"))
            {
                DisplayStatus displayStatus = (DisplayStatus)Enum.Parse(typeof(DisplayStatus), simulator._displayStatusOptions[_selectedDisplayStatusProperty.intValue]);
                simulator.HandleDisplayStatusChanged(displayStatus);
            }
            EditorGUI.EndDisabledGroup();
            
            GUILayout.EndVertical();

            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.BeginVertical();
            GUILayout.Label("Manual Power-Off Event Handler", EditorStyles.boldLabel);

            EditorGUI.BeginDisabledGroup(!EditorApplication.isPlaying);
            if (GUILayout.Button("Invoke OnPowerOffChanged"))
            {
                simulator.HandlePowerOffChanged();
            }
            EditorGUI.EndDisabledGroup();
            GUILayout.EndVertical();

            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.BeginVertical();
            GUILayout.Label("Glass Touch Panel Operation Event Handler", EditorStyles.boldLabel);
            GUILayout.BeginHorizontal();
            GUILayout.Label("TouchType");
            GUILayout.FlexibleSpace();
            _selectedTouchTypeIndexProperty.intValue = EditorGUILayout.Popup(_selectedTouchTypeIndexProperty.intValue, simulator._touchTypeOptions, GUILayout.Width(100));
            GUILayout.EndHorizontal();

            GUILayout.BeginHorizontal();
            GUILayout.Label("TouchOperation");
            GUILayout.FlexibleSpace();
            _selectedTouchOperationIndexProperty.intValue = EditorGUILayout.Popup(_selectedTouchOperationIndexProperty.intValue, simulator._touchOperationOptions, GUILayout.Width(100));
            GUILayout.EndHorizontal();

            GUILayout.BeginHorizontal();
            GUILayout.Label("XCoordinate");
            GUILayout.FlexibleSpace();
            _xCoordinateProperty.intValue = EditorGUILayout.IntField(_xCoordinateProperty.intValue, GUILayout.Width(100));
            GUILayout.EndHorizontal();

            GUILayout.BeginHorizontal();
            GUILayout.Label("YCoordinate");
            GUILayout.FlexibleSpace();
            _yCoordinateProperty.intValue = EditorGUILayout.IntField(_yCoordinateProperty.intValue, GUILayout.Width(100));
            GUILayout.EndHorizontal();

            GUILayout.BeginHorizontal();
            GUILayout.Label("Movement");
            GUILayout.FlexibleSpace();
            _movementProperty.intValue = EditorGUILayout.IntField(_movementProperty.intValue, GUILayout.Width(100));
            GUILayout.EndHorizontal();

            EditorGUI.BeginDisabledGroup(!EditorApplication.isPlaying);
            if (GUILayout.Button("Invoke OnGlassTouchGestureStatusChanged"))
            {
                TouchType touchType = (TouchType)Enum.Parse(typeof(TouchType), simulator._touchTypeOptions[_selectedTouchTypeIndexProperty.intValue]);
                TouchOperation touchOperation = (TouchOperation)Enum.Parse(typeof(TouchOperation), simulator._touchOperationOptions[_selectedTouchOperationIndexProperty.intValue]);
                int xCoordinate = _xCoordinateProperty.intValue;
                int yCoordinate = _yCoordinateProperty.intValue;
                int movement = _movementProperty.intValue;

                simulator.HandleGlassTouchGestureStatusChanged(touchType, touchOperation, xCoordinate, yCoordinate, movement);
            }
            EditorGUI.EndDisabledGroup();

            GUILayout.EndVertical();
            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.Label("Parameters For Other Methods", _titleStyle);
            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.BeginVertical();
            GUILayout.Label("State", EditorStyles.boldLabel);
            GUILayout.BeginHorizontal();
            GUILayout.Label("State");
            GUILayout.FlexibleSpace();
            _stateProperty.intValue = EditorGUILayout.Popup(_stateProperty.intValue, simulator._stateOptions, GUILayout.Width(100));
            GUILayout.EndVertical();

            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.BeginVertical();
            GUILayout.Label("VersionConsistency", EditorStyles.boldLabel);
            GUILayout.BeginHorizontal();
            GUILayout.Label("VersionConsistencyData");
            GUILayout.FlexibleSpace();
            _versionConsistencyResultProperty.stringValue = EditorGUILayout.TextField(_versionConsistencyResultProperty.stringValue, GUILayout.Width(100));
            GUILayout.EndHorizontal();
            GUILayout.EndVertical();

            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.BeginVertical();
            GUILayout.Label("ChargeStatus", EditorStyles.boldLabel);
            GUILayout.BeginHorizontal();
            GUILayout.Label("ChargeStatus");
            GUILayout.FlexibleSpace();
            _chargeStatusProperty.intValue = EditorGUILayout.Popup(_chargeStatusProperty.intValue, simulator._chargeStatusOptions, GUILayout.Width(100));
            GUILayout.EndHorizontal();
            GUILayout.EndVertical();

            GUILayout.Space(20); /////////////////////////////////////////////////////////////////

            GUILayout.EndVertical();

            serializedObject.ApplyModifiedProperties();

            if (GUI.changed || isFirstTime)
            {
                if (!isFirstTime)
                {
                    EditorUtility.SetDirty(target);
                }

                if (!EditorApplication.isPlaying)
                {
                    return;
                }

                // State
                simulator.CurrentState = (State)Enum.Parse(typeof(State), simulator._stateOptions[_stateProperty.intValue]);

                // VersionConsistency
                simulator.UpdateVersionConsistencyResult();

                // GlassStatus
                simulator.UpdateGlassStatusResult();

                // BatteryLevel
                simulator.UpdateBatteryLevelResult();

                // ChargeStatus
                simulator.UpdateChargeStatusResult();

                // SpacesModeOn
                simulator.UpdateSpacesModeOnResult();

                // SpacesModeOff
                simulator.UpdateSpacesModeOffResult();

                // SpacesModeStatus
                simulator.UpdateSpacesModeStatusResult();

                isFirstTime = false;
            }
        }
    }
}
#endif