﻿using NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Runtime;
using UnityEditor;
using UnityEditor.Compilation;
using UnityEngine;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public class MRModeAutoSwitcherCopyHelper
    {
        public readonly string SourceScriptPath = "Packages/com.nttqonoq.devices.android.mirza.configuration-tool/ConfigurationTool/Scripts/Runtime/MrModeSwitcher.cs";

        public readonly string SourcePrefabPath = "Packages/com.nttqonoq.devices.android.mirza.configuration-tool/ConfigurationTool/Prefabs/MR Mode Auto Switcher.prefab";

        [InitializeOnLoadMethod]
        public static void RebuildFinisher()
        {
            if (SessionState.GetBool("WAITING_FOR_RELOAD_MRSwitcher", false))
            {
                SessionState.SetBool("WAITING_FOR_RELOAD_MRSwitcher", false);

                var scriptTargetPath = SessionState.GetString("Reload_MRSwitcherScriptPath", "");
                var prefabTargetPath = SessionState.GetString("Reload_MRSwitcherPrefabPath", "");
                var prefab = AssetDatabase.LoadAssetAtPath<GameObject>(prefabTargetPath);

                var mrModeSwitcherScript = AssetDatabase.LoadAssetAtPath<MonoScript>(scriptTargetPath);

                if (mrModeSwitcherScript != null && mrModeSwitcherScript.GetClass() != null)
                {
                    prefab.AddComponent(mrModeSwitcherScript.GetClass());
                    var obj = PrefabUtility.InstantiatePrefab(prefab);
                    Undo.RegisterCreatedObjectUndo(obj, "Add MR Mode Auto Switcher");

                    Selection.activeGameObject = obj as GameObject;
                }

                // 不要なSessionStateを削除
                SessionState.EraseString("Reload_MRSwitcherScriptPath");
                SessionState.EraseString("Reload_MRSwitcherPrefabPath");
                SessionState.EraseBool("WAITING_FOR_RELOAD_MRSwitcher");
            }
        }

        public void RebuildMRModeAutoSwitcherPrefab(string prefabTargetPath, string scriptTargetPath)
        {
#if USING_SNAPDRAGON_SPACES_SDK && USING_MIRZA_SDK

            // Prefab内のMrModeSwitcher.csの代わりにscriptTargetPathのMrModeSwitcherクラスをprefabにアタッチする
            var prefab = AssetDatabase.LoadAssetAtPath<GameObject>(prefabTargetPath);
            if (prefab != null)
            {
                var mrModeSwitcher = prefab.GetComponent<MrModeSwitcher>();
                if (mrModeSwitcher != null)
                {
                    Object.DestroyImmediate(mrModeSwitcher, true);
                }

                AssetDatabase.Refresh();

                // 強制コンパイルを行う
                CompilationPipeline.RequestScriptCompilation();

                // コンパイル完了後かつリロード後に処理したい場合はフラグを立てる
                SessionState.SetBool("WAITING_FOR_RELOAD_MRSwitcher", true);
                SessionState.SetString("Reload_MRSwitcherScriptPath", scriptTargetPath);
                SessionState.SetString("Reload_MRSwitcherPrefabPath", prefabTargetPath);
            }
#else
            EditorUtility.DisplayDialog("Error", "USING_SNAPDRAGON_SPACES_SDK and USING_MIRZA_SDK are not enabled.\n\n" +
                "USING_SNAPDRAGON_SPACES_SDK can be enabled via the Spaces Configuration Tools.\n\n" +
                "USING_MIRZA_SDK is enabled during MiRZA Library installation.\n\n" +
                "You can also activate them here: \n" +
                "Project Settings > Player Settings > Scripting Define Symbols", "OK");
            return;

#endif
        }
    }
}
