#if UNITY_EDITOR

using UnityEditor;
using UnityEngine;
using UnityEngine.UIElements;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public static class LabelEditorExtensions
    {
        public static void Set(this Label label, string text, Color color, string tooltip = null)
        {
            label.text = text;
            label.style.color = color;
            if(tooltip != null)
            {
                label.tooltip = tooltip;
            }

            if (EditorGUIUtility.isProSkin)
            {
                label.style.backgroundColor =  StyleKeyword.Null;
            }
            else
            {
                label.style.backgroundColor = new Color(56 / 255f, 56 / 255f, 56 / 255f);
            }
        }
    }
}

#endif