﻿using UnityEditor;
using UnityEngine;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public static class EditorMenu
    {
        [MenuItem("GameObject/XR/MiRZA/Dual Render Fusion Controller")]
        public static void AddDualRenderFusionControllerPrefabToScene()
        {
            Utility.TryAddDualRenderFusionControllerPrefabToScene();
        }

        [MenuItem("GameObject/XR/MiRZA/Render Camera")]
        public static void AddRenderCameraPrefabToScene()
        {
            Utility.TryAddRenderCameraPrefabToScene();
        }

        [MenuItem("GameObject/XR/MiRZA/Add QCHT Control Box", false, 10)]
        private static void AddQCHTControlBox(MenuCommand menuCommand)
        {
            if (AssemblyUtility.FindAssemblyByName("QCHT.Interactions") == null)
            {
                EditorUtility.DisplayDialog("MiRZA Configuration Tool", "QCHT.Interactions assembly not found.\nPlease ensure the QCHT Unity Interactions is installed.", "OK");
                return;
            }
            string undoGroupName = "Add QCHT Control Box";

            GameObject selectedObject = menuCommand.context as GameObject;
            if (PrefabUtility.IsPartOfPrefabInstance(selectedObject))
            {
                EditorUtility.DisplayDialog("MiRZA Configuration Tool", "Add QCHT Control Box does not support Prefab instances.\nPlease Unpack the Prefab before use.", "OK");
                return;
            }

            if (selectedObject != null)
            {
                GameObject newObject = new GameObject("QCHTControlBox - " + selectedObject.name);
                Transform originalParent = selectedObject.transform.parent;
                newObject.transform.position = selectedObject.transform.position;

                Undo.RegisterCreatedObjectUndo(newObject, undoGroupName);
                Undo.SetTransformParent(newObject.transform, originalParent, undoGroupName);
                Undo.SetTransformParent(selectedObject.transform, newObject.transform, undoGroupName);

                newObject.transform.parent = originalParent;
                selectedObject.transform.parent = newObject.transform;
                AssemblyUtility.AddComponentToGameObject(newObject, "QCHT.Interactions", "QCHT.Interactions.Distal.ControlBox.QCHTControlBox");
                Selection.activeGameObject = newObject;
            }
            else
            {
                Debug.LogWarning("No GameObject selected.\nSelect the GameObject to which you want to add the QCHT Control Box.");
            }
        }

        [MenuItem("GameObject/XR/MiRZA/Add QCHT Control Box", true, 10)]
        private static bool ValidateAddQCHTControlBoxMenu()
        {
            return Selection.activeGameObject != null;
        }
    }
}