﻿using UnityEditor.Build;
using UnityEditor;
using System.Linq;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public static class DefineUtility
    {
        public static readonly string UsingMirzaDefine = "USING_MIRZA_SDK";

        public static void AddDefine(string defineSymbol)
        {
            var target = NamedBuildTarget.Android;
            var defines = PlayerSettings.GetScriptingDefineSymbols(target);

            if (!defines.Split(';').Contains(defineSymbol))
            {
                defines += $";{defineSymbol}";
                PlayerSettings.SetScriptingDefineSymbols(target, defines);
            }
        }
        public static void RemoveDefine(string defineSymbol)
        {
            var target = NamedBuildTarget.Android;
            var defines = PlayerSettings.GetScriptingDefineSymbols(target);
            if (defines.Split(';').Contains(defineSymbol))
            {
                defines = string.Join(";", defines.Split(';').Where(s => s != defineSymbol));
                PlayerSettings.SetScriptingDefineSymbols(target, defines);
            }
        }

    }
}
