using System.IO;
using System.Linq;
using UnityEditor;
using UnityEditor.PackageManager;
using UnityEditor.PackageManager.Requests;
using UnityEngine;
using UnityEngine.UIElements;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    public class DebugPanel: BasePanel
    {
        private ConfigurationWindow _configurationWindow;

        private AddRequest _addInGameDebugConsoleRequest;

        public DebugPanel(VisualTreeAsset visualTreeAsset, ConfigurationWindow window) : base(visualTreeAsset, window)
        {
            AddOpenLinkButtonClickListener("OpenDebugManualButton", "setup/mirza-sdk/categories/debug");

            AddButtonClickListener("FrameTimingStatsButton", () =>
            {
                PlayerSettings.enableFrameTimingStats = true;
                Window.Validate();
            });

            AddButtonClickListener("AddDebugPrefabButton", () =>
            {
                // Check if XROrigin is present in the scene
                var xrOriginObject = Utility.FindFirstComponentByName("XROrigin");
                if (xrOriginObject == null)
                {
                    EditorUtility.DisplayDialog("Error", "XROrigin not found in the scene. Please add XROrigin.", "OK");
                    return;
                }

                var asset = AssetDatabase.FindAssets("IngameDebugConsoleForMirza");
                if (asset.Length > 0)
                {
                    var path = AssetDatabase.GUIDToAssetPath(asset[0]);
                    var prefab = AssetDatabase.LoadAssetAtPath<GameObject>(path);
                    if (prefab != null)
                    {
                        var instance = PrefabUtility.InstantiatePrefab(prefab);
                        Undo.RegisterCreatedObjectUndo(instance, "Add Debug Console Prefab");
                        Window.Validate();
                        Selection.activeObject = instance;
                    }
                }
            });

            AddButtonClickListener("ImportInGameDebugConsoleButton", () =>
            {
                var path = Path.GetFullPath(AssetDatabase.GetAssetPath(Window.InGameDebugConsoleAsset));
                var copyPath = Path.Combine(Application.dataPath, "../Packages/com.yasirkula.ingamedebugconsole-1.8.1.tgz");
                File.Copy(path, copyPath, true);
                if (!File.Exists(copyPath))
                {
                    EditorUtility.DisplayDialog("Error", "Failed to copy In-game Debug Console package.", "OK");
                }

                _addInGameDebugConsoleRequest = Client.Add("file:" + "../Packages/com.yasirkula.ingamedebugconsole-1.8.1.tgz");
                EditorApplication.update += CheckAddInGameDebugConsoleRequest;
            });
        }

        private void CheckAddInGameDebugConsoleRequest()
        {
            if (_addInGameDebugConsoleRequest == null)
            {
                EditorApplication.update -= CheckAddInGameDebugConsoleRequest;
                return;
            }

            if (_addInGameDebugConsoleRequest.IsCompleted)
            {
                if (_addInGameDebugConsoleRequest.Status == StatusCode.Success)
                {
                    EditorUtility.DisplayDialog("Success", "In-game Debug Console imported successfully.", "OK");
                }
                else
                {
                    EditorUtility.DisplayDialog("Error", "Failed to import In-game Debug Console.", "OK");
                    Debug.Log(_addInGameDebugConsoleRequest.Error.message);
                }
                _addInGameDebugConsoleRequest = null;
            }
        }

        public override void RefreshPanel()
        {
            var frameTimingStatsButton = PanelParent.Q<Button>("FrameTimingStatsButton");
            if (Report.DebugParams.FrameTimingStatsEnabled.Actual == "True")
            {
                frameTimingStatsButton.text = "Frame Timing Stats Enabled";
                // Disable button
                frameTimingStatsButton.SetEnabled(false);
            }
            else
            {
                frameTimingStatsButton.text = "Enable Frame Timing Stats";
                // Enable button
                frameTimingStatsButton.SetEnabled(true);
            }

            var debugPrefabButton = PanelParent.Q<Button>("AddDebugPrefabButton");
            if (Report.DebugParams.DebugPrefabAdded.Exists)
            {
                debugPrefabButton.text = "Debug Console Prefab Added";
                // Disable button
                debugPrefabButton.SetEnabled(false);
            }
            else
            {
                debugPrefabButton.text = "Add Debug Console Prefab";
                // Enable button
                debugPrefabButton.SetEnabled(true);
            }
        }
    }
}