﻿using System.IO;
using UnityEditor;
using UnityEditor.SceneManagement;
using UnityEngine;

namespace NTTQONOQ.Android.MiRZA.SDK.ConfigurationTool.Editor
{
    /// <summary>
    /// アセットのコピー、namespaceの置換、シーンのオープンなどを行うユーティリティクラス
    /// </summary>
    public static class AssetUtility
    {
        public static readonly string AssetPath = "Assets/MiRZA";
        public static readonly string ScriptsSubFolderName = $"Scripts";
        public static readonly string PrefabSubFolderName = $"Prefabs";

        public static void CopyAsset(string fromFilePath, string toFilePath)
        {
            var toFolderPath = Path.GetDirectoryName(toFilePath);
            if (!Directory.Exists(toFolderPath))
            {
                Directory.CreateDirectory(toFolderPath);
            }
            File.Copy(fromFilePath, toFilePath, true);
        }

        public static void OpenAndSelectScene(string scenePath)
        {
            AssetDatabase.Refresh();
            EditorSceneManager.OpenScene(scenePath);
            Object sceneAsset = AssetDatabase.LoadAssetAtPath<Object>(scenePath);
            if (sceneAsset != null)
            {
                Selection.activeObject = sceneAsset;
                EditorGUIUtility.PingObject(sceneAsset);
            }
        }
    }
}