using System;

namespace com.nttqonoq.devices.android.mirzalibrary
{
    // ----------------------------------------------------------
    // MirzaPluginの提供機能IF
    // ----------------------------------------------------------

    public interface IMirzaPlugin
    {
        // モニタリング開始
        void StartMonitoring();

        // モニタリング停止
        void StopMonitoring();

        // ログ出力設定
        void SetLogEnable(bool enabled);

        // バージョン整合性を確認
        Result<string> CheckVersionConsistency();

        // グラス状態取得
        Result<GlassStatus> GetGlassStatus();

        // グラス状態取得（非同期）
        void GetGlassStatusAsync(Action<Result<GlassStatus>> onResult);

        // 電池残量取得
        Result<int> GetBatteryLevel();

        // 電池残量取得（非同期）
        void GetBatteryLevelAsync(Action<Result<int>> onResult);

        // 充電状態取得
        Result<ChargeStatus> GetChargeStatus();

        // 充電状態取得（非同期）
        void GetChargeStatusAsync(Action<Result<ChargeStatus>> onResult);

        // Spacesモード有効化
        Result<int> SpacesModeOn();

        // Spacesモード有効化（非同期）
        void SpacesModeOnAsync(Action<Result<int>> onResult);

        // Spacesモード無効化
        Result<int> SpacesModeOff();

        // Spacesモード無効化（非同期）
        void SpacesModeOffAsync(Action<Result<int>> onResult);

        // マイク切替を実行
        Result<SwitchMicrophoneStatus> SwitchMicrophone(MicMode wearingMicMode, MicMode frontMicMode, MixMode mixMode);

        // マイク切替を実行（非同期）
        void SwitchMicrophoneAsync(MicMode wearingMicMode, MicMode frontMicMode, MixMode mixMode, Action<Result<SwitchMicrophoneStatus>> onResult);

        // SpacesモードのMiRZAアプリへ遷移
        Result<SpacesModeStatus> TransitionToMirzaAppInSpacesMode();

        // ライブラリバージョンを取得
        string GetVersion();

        // Spacesモード状態を取得
        Result<SpacesModeStatus> GetSpacesModeStatus();

        // Spacesモード状態を取得（非同期）
        void GetSpacesModeStatusAsync(Action<Result<SpacesModeStatus>> onResult);

        // サービスステータスのイベントハンドラ
        event Action<ServiceState> OnServiceStateChanged;

        // グラス状態のイベントハンドラ
        event Action<GlassStatus> OnGlassStatusChanged;

        // 電池残量のイベントハンドラ
        event Action<int> OnBatteryLevelChanged;

        // Spacesモードのイベントハンドラ
        event Action<SpacesModeStatus> OnSpacesModeStatusChanged;

        // 画面表示状態のイベントハンドラ
        event Action<DisplayStatus> OnDisplayStatusChanged;

        // 手動電源OFFのイベントハンドラ
        event Action OnPowerOffChanged;

        // グラスタッチパネル操作情報のイベントハンドラ
        event Action<GlassTouchGestureStatus> OnGlassTouchGestureStatusChanged;
    }
}