using UnityEngine;

namespace com.nttqonoq.devices.android.mirzalibrary
{
    /// <summary>
    /// タッチの種類 Enum
    /// </summary>
    public enum TouchType
    {
        Tap = 0, // タップ
        Swipe = 1, // スワイプ
        Motion = 2 // モーション
    }

    /// <summary>
    /// タッチ操作の方法 Enum
    /// </summary>
    public enum TouchOperation
    {
        Single = 0, // シングル
        Double = 1, // ダブル
        Triple = 2, // トリプル
        LongPressInitial = 3, // 長押し（初回）
        Previous = 4, // 前
        Next = 5, // 後
        Up = 6, // UP
        Move = 7, // Move
        Down = 8, // Down
        LongPressRepeat = 9 // 長押し（2回以降）
    }

    /// <summary>
    /// グラスのタッチパネル操作情報
    /// </summary>
    public class GlassTouchGestureStatus
    {
        public TouchType Type { get; private set; }
        public TouchOperation Operation { get; private set; }
        public int XCoordinate { get; private set; }
        public int YCoordinate { get; private set; }
        public int Movement { get; private set; }


        public static GlassTouchGestureStatus Convert(AndroidJavaObject javaObject)
        {
            var status = new GlassTouchGestureStatus
            {
                Type = (TouchType)javaObject.Call<AndroidJavaObject>("getTouchType").Call<int>("getCode"),
                Operation =
                    (TouchOperation)javaObject.Call<AndroidJavaObject>("getTouchOperation").Call<int>("getCode"),
                XCoordinate = javaObject.Call<int>("getXCoordinate"),
                YCoordinate = javaObject.Call<int>("getYCoordinate"),
                Movement = javaObject.Call<int>("getMovement")
            };
            return status;
        }
    }
}