using UnityEngine;

namespace com.nttqonoq.devices.android.mirzalibrary
{
    /// <summary>
    /// 接続状態 Enum
    /// </summary>
    public enum ConnectionStatus
    {
        Connected = 0, // 接続済み
        Disconnected = 1, // 未接続
        Unknown = 2 // 不明
    }

    /// <summary>
    /// グラス状態
    /// </summary>
    public class GlassStatus
    {
        public ConnectionStatus BluetoothStatus { get; private set; }
        public ConnectionStatus WifiStatus { get; private set; }
        public bool SpacesAvailable { get; private set; }


        public static GlassStatus Convert(AndroidJavaObject javaObject)
        {
            var status = new GlassStatus
            {
                BluetoothStatus =
                    (ConnectionStatus)javaObject.Call<AndroidJavaObject>("getBluetoothState")
                        .Call<int>("getCode"),
                WifiStatus =
                    (ConnectionStatus)javaObject.Call<AndroidJavaObject>("getWifiState").Call<int>("getCode"),
                SpacesAvailable = javaObject.Call<bool>("isSpacesAvailable")
            };
            return status;
        }
    }
}